/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableRepartitionMapSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KTableRepartitionMap<K, V, K1, V1>
implements KTableRepartitionMapSupplier<K, V, KeyValue<K1, V1>, K1, V1> {
    private final KTableImpl<K, ?, V> parent;
    private final KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> mapper;
    private boolean useVersionedSemantics = false;

    KTableRepartitionMap(KTableImpl<K, ?, V> parent, KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> mapper) {
        this.parent = parent;
        this.mapper = mapper;
    }

    boolean isUseVersionedSemantics() {
        return this.useVersionedSemantics;
    }

    public void setUseVersionedSemantics(boolean useVersionedSemantics) {
        this.useVersionedSemantics = useVersionedSemantics;
    }

    @Override
    public Processor<K, Change<V>, K1, Change<V1>> get() {
        return new KTableMapProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, KeyValue<K1, V1>> view() {
        final KTableValueGetterSupplier<K, V> parentValueGetterSupplier = this.parent.valueGetterSupplier();
        return new KTableValueGetterSupplier<K, KeyValue<K1, V1>>(){

            @Override
            public KTableValueGetter<K, KeyValue<K1, V1>> get() {
                return new KTableMapValueGetter(parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                throw new StreamsException("Underlying state store not accessible due to repartitioning.");
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        throw new IllegalStateException("KTableRepartitionMap should always require sending old values.");
    }

    private class KTableMapProcessor
    extends ContextualProcessor<K, Change<V>, K1, Change<V1>> {
        private boolean isNotUpgrade;

        private KTableMapProcessor() {
        }

        private boolean isNotUpgrade(Map<String, ?> configs) {
            Object upgradeFrom = configs.get("upgrade.from");
            if (upgradeFrom == null) {
                return true;
            }
            switch ((String)upgradeFrom) {
                case "0.10.0": 
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": 
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": 
                case "2.4": 
                case "2.5": 
                case "2.6": 
                case "2.7": 
                case "2.8": 
                case "3.0": 
                case "3.1": 
                case "3.2": 
                case "3.3": 
                case "3.4": {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void init(ProcessorContext<K1, Change<V1>> context) {
            super.init(context);
            this.isNotUpgrade = this.isNotUpgrade(this.context().appConfigs());
        }

        @Override
        public void process(Record<K, Change<V>> record) {
            boolean newPairNotNull;
            if (record.key() == null) {
                throw new StreamsException("Record key for the grouping KTable should not be null.");
            }
            boolean isLatest = record.value().isLatest;
            if (KTableRepartitionMap.this.useVersionedSemantics && !isLatest) {
                return;
            }
            KeyValue newPair = record.value().newValue == null ? null : (KeyValue)KTableRepartitionMap.this.mapper.apply(record.key(), record.value().newValue);
            KeyValue oldPair = record.value().oldValue == null ? null : (KeyValue)KTableRepartitionMap.this.mapper.apply(record.key(), record.value().oldValue);
            boolean oldPairNotNull = oldPair != null && oldPair.key != null && oldPair.value != null;
            boolean bl = newPairNotNull = newPair != null && newPair.key != null && newPair.value != null;
            if (this.isNotUpgrade && oldPairNotNull && newPairNotNull && oldPair.key.equals(newPair.key)) {
                this.context().forward(record.withKey(oldPair.key).withValue(new Change(newPair.value, oldPair.value, isLatest)));
            } else {
                if (oldPairNotNull) {
                    this.context().forward(record.withKey(oldPair.key).withValue(new Change<Object>(null, oldPair.value, isLatest)));
                }
                if (newPairNotNull) {
                    this.context().forward(record.withKey(newPair.key).withValue(new Change<Object>(newPair.value, null, isLatest)));
                }
            }
        }
    }

    private class KTableMapValueGetter
    implements KTableValueGetter<K, KeyValue<K1, V1>> {
        private final KTableValueGetter<K, V> parentGetter;
        private InternalProcessorContext<?, ?> context;

        KTableMapValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.context = (InternalProcessorContext)context;
            this.parentGetter.init(context);
        }

        @Override
        public ValueAndTimestamp<KeyValue<K1, V1>> get(K key) {
            return this.mapValue(key, this.parentGetter.get(key));
        }

        @Override
        public ValueAndTimestamp<KeyValue<K1, V1>> get(K key, long asOfTimestamp) {
            return this.mapValue(key, this.parentGetter.get(key, asOfTimestamp));
        }

        @Override
        public boolean isVersioned() {
            return this.parentGetter.isVersioned();
        }

        @Override
        public void close() {
            this.parentGetter.close();
        }

        private ValueAndTimestamp<KeyValue<K1, V1>> mapValue(K key, ValueAndTimestamp<V> valueAndTimestamp) {
            return ValueAndTimestamp.make((KeyValue)KTableRepartitionMap.this.mapper.apply(key, ValueAndTimestamp.getValueOrNull(valueAndTimestamp)), valueAndTimestamp == null ? this.context.timestamp() : valueAndTimestamp.timestamp());
        }
    }
}

