/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.LeaderElectionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LeaderElectionCommand$
implements Logging {
    public static final LeaderElectionCommand$ MODULE$ = new LeaderElectionCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * Unable to fully structure code
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)commandOptions, (String)"This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = (ElectionType)commandOptions.options.valueOf(commandOptions.electionType());
        jsonFileTopicPartitions = Option$.MODULE$.apply(commandOptions.options.valueOf(commandOptions.pathToJsonFile())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$1(java.lang.String ), (Ljava/lang/String;)Lscala/collection/immutable/Set;)());
        var14_6 = Option$.MODULE$.apply(commandOptions.options.valueOf(commandOptions.partition()));
        var7_7 = Option$.MODULE$.apply(commandOptions.options.valueOf(commandOptions.topic()));
        if (!(var7_7 instanceof Some)) ** GOTO lbl-1000
        topic = (String)((Some)var7_7).value();
        if (var14_6 instanceof Some) {
            partition = (Integer)((Some)var14_6).value();
            v0 = new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition))})));
        } else lbl-1000:
        // 2 sources

        {
            v0 = None$.MODULE$;
        }
        singleTopicPartition = v0;
        topicPartitions = jsonFileTopicPartitions.orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$2(scala.Option ), ()Lscala/Option;)((Option)singleTopicPartition));
        props = (Properties)Option$.MODULE$.apply(commandOptions.options.valueOf(commandOptions.adminClientConfig())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$3(java.lang.String ), (Ljava/lang/String;)Ljava/util/Properties;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$4(), ()Ljava/util/Properties;)());
        props.setProperty("bootstrap.servers", (String)commandOptions.options.valueOf(commandOptions.bootstrapServer()));
        props.setProperty("default.api.timeout.ms", Long.toString(timeout.toMillis()));
        props.setProperty("request.timeout.ms", Long.toString(timeout.toMillis() / 2L));
        adminClient = Admin.create((Properties)props);
        try {
            this.electLeaders(adminClient, electionType, (Option<scala.collection.immutable.Set<TopicPartition>>)topicPartitions);
        }
        finally {
            adminClient.close();
        }
    }

    private scala.collection.immutable.Set<TopicPartition> parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer partitions = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1 & Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringBuilder(53).append("Replica election data contains duplicate partitions: ").append(duplicatePartitions.mkString(",")).toString());
                }
                return partitions.toSet();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Replica election data is missing \"partitions\" field");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Replica election data is empty");
        }
        throw new MatchError(option);
    }

    private void electLeaders(Admin client, ElectionType electionType, Option<scala.collection.immutable.Set<TopicPartition>> topicPartitions) {
        scala.collection.mutable.Map map;
        try {
            java.util.Set partitions = (java.util.Set)topicPartitions.map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.SetHasAsJava((Set)x$2).asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = LeaderElectionCommand$.$anonfun$electLeaders$2(electionType, partitions);
                Object var20_5 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            map = CollectionConverters$.MODULE$.MapHasAsScala((Map)client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while making request");
            throw e;
        }
        scala.collection.mutable.Map electionResults = map;
        scala.collection.mutable.Set succeeded = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set noop = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Map failed = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        electionResults.foreach((Function1 & Serializable)x0$1 -> {
            LeaderElectionCommand$.$anonfun$electLeaders$3(noop, failed, succeeded, x0$1);
            return BoxedUnit.UNIT;
        });
        if (succeeded.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(57).append("Successfully completed leader election (").append(electionType).append(") for partitions ").append(partitions).toString());
        }
        if (noop.nonEmpty()) {
            String partitions = noop.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(45).append("Valid replica already elected for partitions ").append(partitions).toString());
        }
        if (failed.nonEmpty()) {
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringBuilder(32).append(failed.size()).append(" replica(s) could not be elected").toString());
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, exception) -> {
                LeaderElectionCommand$.$anonfun$electLeaders$4(electionType, rootException, topicPartition, exception);
                return BoxedUnit.UNIT;
            };
            failed.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            throw rootException;
        }
    }

    private void validate(LeaderElectionCommandOptions commandOptions) {
        List missingOptions = package$.MODULE$.List().empty();
        if (!commandOptions.options.has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (!commandOptions.options.has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        .colon.colon mutuallyExclusiveOptions = new .colon.colon(commandOptions.topic(), (List)new .colon.colon((Object)commandOptions.allTopicPartitions(), (List)new .colon.colon(commandOptions.pathToJsonFile(), (List)Nil$.MODULE$)));
        switch (mutuallyExclusiveOptions.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)commandOptions.options.has(x$1)))) {
            case 1: {
                break;
            }
            default: {
                throw new AdminCommandFailedException(new StringBuilder(55).append("One and only one of the following options is required: ").append(((IterableOnceOps)mutuallyExclusiveOptions.map((Function1 & Serializable)x$3 -> (String)x$3.options().get(0))).mkString(", ")).toString());
            }
        }
        boolean bl = commandOptions.options.has(commandOptions.partition());
        boolean bl2 = commandOptions.options.has(commandOptions.topic());
        if (bl2 && !bl) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(commandOptions.partition().options().get(0)).toString());
        }
        if (!bl2 && bl) {
            throw new AdminCommandFailedException(new StringBuilder(35).append("Option ").append(commandOptions.partition().options().get(0)).append(" is only allowed if ").append(commandOptions.topic().options().get(0)).append(" is used").toString());
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$run$1(String path) {
        return MODULE$.parseReplicaElectionData(Utils.readFileAsString((String)path));
    }

    public static final /* synthetic */ Option $anonfun$run$2(Option singleTopicPartition$1) {
        return singleTopicPartition$1;
    }

    public static final /* synthetic */ Properties $anonfun$run$3(String config) {
        return Utils.loadProps((String)config);
    }

    public static final /* synthetic */ Properties $anonfun$run$4() {
        return new Properties();
    }

    public static final /* synthetic */ String $anonfun$electLeaders$2(ElectionType electionType$1, java.util.Set partitions$1) {
        return new StringBuilder(36).append("Calling AdminClient.electLeaders(").append(electionType$1).append(", ").append(partitions$1).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$electLeaders$3(scala.collection.mutable.Set noop$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Optional error = (Optional)x0$1._2();
            if (error.isPresent()) {
                if ((Throwable)error.get() instanceof ElectionNotNeededException) {
                    noop$1.$plus$eq((Object)topicPartition);
                    return;
                }
                failed$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), error.get()));
                return;
            }
            succeeded$1.$plus$eq((Object)topicPartition);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$electLeaders$4(ElectionType electionType$1, AdminCommandFailedException rootException$1, TopicPartition topicPartition, Throwable exception) {
        Predef$.MODULE$.println((Object)new StringBuilder(53).append("Error completing leader election (").append(electionType$1).append(") for partition: ").append(topicPartition).append(": ").append(exception).toString());
        rootException$1.addSuppressed(exception);
    }

    private LeaderElectionCommand$() {
    }
}

