/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.event.auth;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.events.Event;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.event.auth.entity.JpaAuthEventEntity;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.util.EnumWithStableIndex;

public class JpaAuthEventModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaAuthEventEntity, Event, JpaAuthEventModelCriteriaBuilder> {
    private static final Map<String, String> FIELD_TO_JSON_PROP = new HashMap<String, String>();

    public JpaAuthEventModelCriteriaBuilder() {
        super(JpaAuthEventModelCriteriaBuilder::new);
    }

    private JpaAuthEventModelCriteriaBuilder(JpaPredicateFunction<JpaAuthEventEntity> predicateFunc) {
        super(JpaAuthEventModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaAuthEventModelCriteriaBuilder compare(SearchableModelField<? super Event> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == Event.SearchableFields.REALM_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == Event.SearchableFields.CLIENT_ID || modelField == Event.SearchableFields.USER_ID || modelField == Event.SearchableFields.IP_ADDRESS) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.equal(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LE: {
                if (modelField == Event.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.le((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LT: {
                if (modelField == Event.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.lt((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case GE: {
                if (modelField == Event.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.ge((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == Event.SearchableFields.EVENT_TYPE) {
                    Set values = super.getValuesForInOperator(value, modelField).stream().map(o -> ((EnumWithStableIndex)o).getStableIndex()).collect(Collectors.toSet());
                    if (values.isEmpty()) {
                        return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaAuthEventModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}).as(Integer.class));
                        values.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }

    static {
        FIELD_TO_JSON_PROP.put(Event.SearchableFields.CLIENT_ID.getName(), "fClientId");
        FIELD_TO_JSON_PROP.put(Event.SearchableFields.USER_ID.getName(), "fUserId");
        FIELD_TO_JSON_PROP.put(Event.SearchableFields.IP_ADDRESS.getName(), "fIpAddress");
        FIELD_TO_JSON_PROP.put(Event.SearchableFields.EVENT_TYPE.getName(), "fType");
    }
}

