/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.realm.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaComponentMetadata;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmEntity;

@Entity
@Table(name="kc_component")
@EnhancementInfo(version="6.2.5.Final")
public class JpaComponentEntity
extends UpdatableEntity.Impl
implements MapComponentEntity,
JpaRootVersionedEntity,
JpaChildEntity<JpaRealmEntity>,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String providerType;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaComponentMetadata metadata;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_root")
    JpaRealmEntity root;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaComponentEntity() {
        this.metadata = new JpaComponentMetadata();
    }

    public JpaComponentEntity(DeepCloner cloner) {
        this.metadata = new JpaComponentMetadata(cloner);
    }

    @Override
    public JpaRealmEntity getParent() {
        return this.$$_hibernate_read_root();
    }

    public void setParent(JpaRealmEntity root) {
        this.$$_hibernate_write_root(root);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer version) {
        this.$$_hibernate_read_metadata().setEntityVersion(version);
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_COMPONENT;
    }

    public String getName() {
        return this.$$_hibernate_read_metadata().getName();
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public String getProviderId() {
        return this.$$_hibernate_read_metadata().getProviderId();
    }

    public void setProviderId(String providerId) {
        this.$$_hibernate_read_metadata().setProviderId(providerId);
    }

    public String getProviderType() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getProviderType();
        }
        return this.$$_hibernate_read_providerType();
    }

    public void setProviderType(String providerType) {
        this.$$_hibernate_read_metadata().setProviderType(providerType);
    }

    public String getSubType() {
        return this.$$_hibernate_read_metadata().getSubType();
    }

    public void setSubType(String subType) {
        this.$$_hibernate_read_metadata().setSubType(subType);
    }

    public String getParentId() {
        return this.$$_hibernate_read_metadata().getParentId();
    }

    public void setParentId(String parentId) {
        this.$$_hibernate_read_metadata().setParentId(parentId);
    }

    public Map<String, List<String>> getConfig() {
        return this.$$_hibernate_read_metadata().getConfig();
    }

    public void setConfig(Map<String, List<String>> config) {
        this.$$_hibernate_read_metadata().setConfig(config);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaComponentEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaComponentEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_providerType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.providerType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "providerType", (Object)this.providerType);
        }
        return this.providerType;
    }

    public void $$_hibernate_write_providerType(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.providerType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "providerType", (Object)this.providerType, (Object)string);
            return;
        }
        this.providerType = string;
    }

    public JpaComponentMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaComponentMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public JpaRealmEntity $$_hibernate_read_root() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaRealmEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "root", (Object)this.root);
        }
        return this.root;
    }

    public void $$_hibernate_write_root(JpaRealmEntity jpaRealmEntity) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaRealmEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "root", (Object)this.root, (Object)jpaRealmEntity);
            return;
        }
        this.root = jpaRealmEntity;
    }
}

