/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandStep;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.util.StringUtil;

public class CommandScope {
    public static final Pattern NO_PREFIX_PATTERN = Pattern.compile(".*\\.");
    private final CommandDefinition commandDefinition;
    private final SortedMap<String, Object> argumentValues = new TreeMap<String, Object>();
    private final Map<Class<?>, Object> dependencies = new HashMap();
    private final String completeConfigPrefix;
    private final String shortConfigPrefix;
    private OutputStream outputStream;

    public CommandScope(String ... commandName) throws CommandExecutionException {
        this.setOutput(System.out);
        CommandFactory commandFactory = Scope.getCurrentScope().getSingleton(CommandFactory.class);
        this.commandDefinition = commandFactory.getCommandDefinition(commandName);
        this.completeConfigPrefix = "liquibase.command." + StringUtil.join(Arrays.asList(this.getCommand().getName()), ".");
        this.shortConfigPrefix = "liquibase.command";
    }

    public CommandDefinition getCommand() {
        return this.commandDefinition;
    }

    public String getCompleteConfigPrefix() {
        return this.completeConfigPrefix;
    }

    public CommandScope addArgumentValue(String argument, Object value) {
        this.argumentValues.put(argument, value);
        return this;
    }

    public <T> CommandScope addArgumentValue(CommandArgumentDefinition<T> argument, T value) {
        this.argumentValues.put(argument.getName(), value);
        return this;
    }

    public <T> ConfiguredValue<T> getConfiguredValue(CommandArgumentDefinition<T> argument) {
        ConfigurationDefinition<T> noCommandConfigDef;
        ConfiguredValue<T> noCommandNameProvidedValue;
        ConfigurationDefinition<T> configDef = this.createConfigurationDefinition(argument, true);
        ConfiguredValue<T> providedValue = configDef.getCurrentConfiguredValue(new CommandScopeValueProvider());
        if ((!providedValue.found() || providedValue.wasDefaultValueUsed()) && (noCommandNameProvidedValue = (noCommandConfigDef = this.createConfigurationDefinition(argument, false)).getCurrentConfiguredValue()).found() && !noCommandNameProvidedValue.wasDefaultValueUsed()) {
            providedValue = noCommandNameProvidedValue;
        }
        return providedValue;
    }

    public <T> T getArgumentValue(CommandArgumentDefinition<T> argument) {
        T value = this.getConfiguredValue(argument).getValue();
        return argument.getValueConverter().convert(value);
    }

    public CommandScope provideDependency(Class<?> clazz, Object value) {
        this.dependencies.put(clazz, value);
        return this;
    }

    public <T> Object getDependency(Class<T> clazz) {
        return this.dependencies.get(clazz);
    }

    public CommandScope setOutput(OutputStream outputStream) {
        this.outputStream = outputStream != null ? new UnclosableOutputStream(outputStream) : null;
        return this;
    }

    public void validate() throws CommandValidationException {
        for (ConfigurationValueProvider configurationValueProvider : Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getProviders()) {
            configurationValueProvider.validate(this);
        }
        for (CommandArgumentDefinition commandArgumentDefinition : this.commandDefinition.getArguments().values()) {
            commandArgumentDefinition.validate(this);
        }
        List<CommandStep> pipeline = this.commandDefinition.getPipeline();
        Scope.getCurrentScope().getLog(this.getClass()).fine("Pipeline for command '" + StringUtil.join(this.commandDefinition.getName(), " ") + ": " + StringUtil.join(pipeline, " then ", obj -> obj.getClass().getName()));
        for (CommandStep step : pipeline) {
            step.validate(this);
        }
    }

    public CommandResults execute() throws CommandExecutionException {
        CommandResultsBuilder resultsBuilder = new CommandResultsBuilder(this, this.outputStream);
        List<CommandStep> pipeline = this.commandDefinition.getPipeline();
        this.validate();
        Scope.getCurrentScope().addMdcValue("liquibaseOperation", StringUtil.join(this.commandDefinition.getName(), "-"));
        try {
            for (CommandStep command : pipeline) {
                command.run(resultsBuilder);
            }
            for (int i = pipeline.size() - 1; i >= 0; --i) {
                CommandStep command;
                command = pipeline.get(i);
                if (!(command instanceof CleanUpCommandStep)) continue;
                ((CleanUpCommandStep)((Object)command)).cleanUp(resultsBuilder);
            }
        }
        catch (Exception e) {
            if (e instanceof CommandExecutionException) {
                throw (CommandExecutionException)e;
            }
            throw new CommandExecutionException(e);
        }
        finally {
            try {
                if (this.outputStream != null) {
                    this.outputStream.flush();
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Error flushing command output stream: " + e.getMessage(), e);
            }
        }
        return resultsBuilder.build();
    }

    private <T> ConfigurationDefinition<T> createConfigurationDefinition(CommandArgumentDefinition<T> argument, boolean includeCommandName) {
        String key = includeCommandName ? this.completeConfigPrefix : this.shortConfigPrefix;
        return new ConfigurationDefinition.Builder(key).define(argument.getName(), argument.getDataType()).addAliases(argument.getAliases()).setDefaultValue(argument.getDefaultValue()).setDescription(argument.getDescription()).setValueHandler(argument.getValueConverter()).setValueObfuscator(argument.getValueObfuscator()).buildTemporary();
    }

    private class CommandScopeValueProvider
    extends AbstractMapConfigurationValueProvider {
        private CommandScopeValueProvider() {
        }

        @Override
        public int getPrecedence() {
            return -1;
        }

        @Override
        protected Map<?, ?> getMap() {
            return CommandScope.this.argumentValues;
        }

        @Override
        protected String getSourceDescription() {
            return "Command argument";
        }

        @Override
        protected boolean keyMatches(String wantedKey, String storedKey) {
            if (wantedKey.contains(".")) {
                return super.keyMatches(NO_PREFIX_PATTERN.matcher(wantedKey).replaceFirst(""), storedKey);
            }
            return super.keyMatches(wantedKey, storedKey);
        }
    }

    private static class UnclosableOutputStream
    extends FilterOutputStream {
        public UnclosableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.flush();
        }
    }
}

