/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;

public class AlterTableUniqueIndexDelegate
extends AlterTableUniqueDelegate {
    public AlterTableUniqueIndexDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        if (uniqueKey.hasNullableColumn()) {
            return Index.buildSqlCreateIndexString(context, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.getColumns(), uniqueKey.getColumnOrderMap(), true, metadata);
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey, metadata, context);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        if (uniqueKey.hasNullableColumn()) {
            return Index.buildSqlDropIndexString(uniqueKey.getName(), context.format(uniqueKey.getTable().getQualifiedTableName()));
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey, metadata, context);
    }
}

