/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import java.util.IdentityHashMap;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public interface SqmCopyContext {
    public <T> T getCopy(T var1);

    public <T> T registerCopy(T var1, T var2);

    public static SqmCopyContext simpleContext() {
        final IdentityHashMap map = new IdentityHashMap();
        return new SqmCopyContext(){

            @Override
            public <T> T getCopy(T original) {
                if (original instanceof SqmPath) {
                    return (T)this.getPathCopy((SqmPath)original);
                }
                return (T)map.get(original);
            }

            @Override
            public <T> T registerCopy(T original, T copy) {
                T old = map.put(original, copy);
                if (old != null) {
                    throw new IllegalArgumentException("Already registered a copy: " + old);
                }
                return copy;
            }

            private <T extends SqmPath<?>> T getPathCopy(T original) {
                SqmPath existing = (SqmPath)map.get(original);
                if (existing != null) {
                    return (T)existing;
                }
                SqmPath<?> root = this.getRoot(original);
                if (root != original) {
                    root.copy(this);
                    return (T)((SqmPath)map.get(original));
                }
                return null;
            }

            private SqmPath<?> getRoot(SqmPath<?> path) {
                if (path.getLhs() != null) {
                    return this.getRoot((SqmPath<?>)path.getLhs());
                }
                return path;
            }
        };
    }
}

