/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.channel.CIBAAuthenticationRequest;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelTokenRequestContext;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelTokenResponseContext;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.CibaRootEndpoint;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.utils.ProfileHelper;

public class CibaGrantType {
    private static final Logger logger = Logger.getLogger(CibaGrantType.class);
    public static final String IS_CONSENT_REQUIRED = "is_consent_required";
    public static final String LOGIN_HINT = "login_hint";
    public static final String LOGIN_HINT_TOKEN = "login_hint_token";
    public static final String BINDING_MESSAGE = "binding_message";
    public static final String AUTH_REQ_ID = "auth_req_id";
    public static final String CLIENT_NOTIFICATION_TOKEN = "client_notification_token";
    public static final String REQUESTED_EXPIRY = "requested_expiry";
    public static final String USER_CODE = "user_code";
    public static final String REQUEST = "request";
    public static final String REQUEST_URI = "request_uri";
    public static final String ADDITIONAL_CALLBACK_PARAMS_PREFIX = "ciba_callback_response_param_";
    public static final String ADDITIONAL_BACKCHANNEL_REQ_PARAMS_PREFIX = "ciba_backchannel_request_param_";
    private final MultivaluedMap<String, String> formParams;
    private final ClientModel client;
    private final KeycloakSession session;
    private final TokenEndpoint tokenEndpoint;
    private final RealmModel realm;
    private final EventBuilder event;
    private final Cors cors;

    public static UriBuilder authorizationUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "resolveExtension").resolveTemplate("extension", (Object)"ciba", false).path(CibaRootEndpoint.class, "authorize");
    }

    public static UriBuilder authenticationUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "resolveExtension").resolveTemplate("extension", (Object)"ciba", false).path(CibaRootEndpoint.class, "authenticate");
    }

    public CibaGrantType(MultivaluedMap<String, String> formParams, ClientModel client, KeycloakSession session, TokenEndpoint tokenEndpoint, RealmModel realm, EventBuilder event, Cors cors) {
        this.formParams = formParams;
        this.client = client;
        this.session = session;
        this.tokenEndpoint = tokenEndpoint;
        this.realm = realm;
        this.event = event;
        this.cors = cors;
    }

    public Response cibaGrant() {
        CIBAAuthenticationRequest request;
        ProfileHelper.requireFeature(Profile.Feature.CIBA);
        if (!this.realm.getCibaPolicy().isOIDCCIBAGrantEnabled(this.client)) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Client not allowed OIDC CIBA Grant", Response.Status.BAD_REQUEST);
        }
        String jwe = (String)this.formParams.getFirst((Object)AUTH_REQ_ID);
        if (jwe == null) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing parameter: auth_req_id", Response.Status.BAD_REQUEST);
        }
        logger.tracev("CIBA Grant :: authReqId = {0}", (Object)jwe);
        try {
            request = CIBAAuthenticationRequest.deserialize(this.session, jwe);
        }
        catch (Exception e) {
            logger.warnf("illegal format of auth_req_id : e.getMessage() = %s", (Object)e.getMessage());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid Auth Req ID", Response.Status.BAD_REQUEST);
        }
        request.setClient(this.client);
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new BackchannelTokenRequestContext(request, this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        OAuth2DeviceCodeModel deviceCode = DeviceGrantType.getDeviceByDeviceCode(this.session, this.realm, this.client, this.event, request.getId());
        if (deviceCode == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid auth_req_id", Response.Status.BAD_REQUEST);
        }
        if (deviceCode.isExpired()) {
            CibaGrantType.logDebug("expired.", request);
            throw new CorsErrorResponseException(this.cors, "expired_token", "authentication timed out", Response.Status.BAD_REQUEST);
        }
        if (!DeviceGrantType.isPollingAllowed(this.session, deviceCode)) {
            CibaGrantType.logDebug("polling.", request);
            throw new CorsErrorResponseException(this.cors, "slow_down", "too early to access", Response.Status.BAD_REQUEST);
        }
        if (deviceCode.isDenied()) {
            CibaGrantType.logDebug("denied.", request);
            throw new CorsErrorResponseException(this.cors, "access_denied", "not authorized", Response.Status.BAD_REQUEST);
        }
        if (deviceCode.isPending()) {
            CibaGrantType.logDebug("not yet authenticated by Authentication Device or auth_req_id has already been used to get tokens.", request);
            throw new CorsErrorResponseException(this.cors, "authorization_pending", "The authorization request is still pending as the end-user hasn't yet been authenticated.", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = this.createUserSession(request, deviceCode.getAdditionalParams());
        UserModel user = userSession.getUser();
        DeviceGrantType.removeDeviceByDeviceCode(this.session, request.getId());
        String scopeParam = request.getScope();
        if (!TokenManager.verifyConsentStillAvailable(this.session, user, this.client, TokenManager.getRequestedClientScopes(scopeParam, this.client))) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Client no longer has requested consent from user", Response.Status.BAD_REQUEST);
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(userSession.getAuthenticatedClientSessionByClient(this.client.getId()), scopeParam, this.session);
        int authTime = Time.currentTime();
        userSession.setNote("AUTH_TIME", String.valueOf(authTime));
        return this.tokenEndpoint.createTokenResponse(user, userSession, clientSessionCtx, scopeParam, true, s -> new BackchannelTokenResponseContext(request, this.formParams, clientSessionCtx, (TokenManager.AccessTokenResponseBuilder)s));
    }

    private UserSessionModel createUserSession(CIBAAuthenticationRequest request, Map<String, String> additionalParams) {
        UserModel user;
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(this.realm);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setProtocol("openid-connect");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", request.getScope());
        if (additionalParams != null) {
            for (String paramName : additionalParams.keySet()) {
                authSession.setClientNote(ADDITIONAL_CALLBACK_PARAMS_PREFIX + paramName, additionalParams.get(paramName));
            }
        }
        if (request.getOtherClaims() != null) {
            for (String paramName : request.getOtherClaims().keySet()) {
                authSession.setClientNote(ADDITIONAL_BACKCHANNEL_REQ_PARAMS_PREFIX + paramName, request.getOtherClaims().get(paramName).toString());
            }
        }
        if ((user = this.session.users().getUserById(this.realm, request.getSubject())) == null) {
            this.event.error("username_missing");
            throw new ErrorResponseException("invalid_grant", "Could not identify user", Response.Status.BAD_REQUEST);
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        logger.debugf("CIBA Grant :: user model found. user.getId() = %s, user.getEmail() = %s, user.getUsername() = %s.", (Object)user.getId(), (Object)user.getEmail(), (Object)user.getUsername());
        authSession.setAuthenticatedUser(user);
        if (user.getRequiredActionsStream().count() > 0L) {
            this.event.error("resolve_required_actions");
            throw new ErrorResponseException("invalid_grant", "Account is not fully set up", Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext context = AuthenticationProcessor.attachSession(authSession, null, this.session, this.realm, this.session.getContext().getConnection(), this.event);
        UserSessionModel userSession = context.getClientSession().getUserSession();
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "User session is not found", Response.Status.BAD_REQUEST);
        }
        UserConsentModel grantedConsent = this.session.users().getConsentByClient(this.realm, user.getId(), this.client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(this.client);
            this.session.users().addConsent(this.realm, user.getId(), grantedConsent);
            if (logger.isTraceEnabled()) {
                grantedConsent.getGrantedClientScopes().forEach(i -> logger.tracef("CIBA Grant :: Consent granted. %s", (Object)i.getName()));
            }
        }
        boolean updateConsentRequired = false;
        for (String clientScopeId : authSession.getClientScopes()) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.realm, (ClientModel)this.client, (String)clientScopeId);
            if (clientScope == null || grantedConsent.isClientScopeGranted(clientScope) || !clientScope.isDisplayOnConsentScreen()) continue;
            grantedConsent.addGrantedClientScope(clientScope);
            updateConsentRequired = true;
        }
        if (updateConsentRequired) {
            this.session.users().updateConsent(this.realm, user.getId(), grantedConsent);
            if (logger.isTraceEnabled()) {
                grantedConsent.getGrantedClientScopes().forEach(i -> logger.tracef("CIBA Grant :: Consent updated. %s", (Object)i.getName()));
            }
        }
        this.event.detail("consent", "consent_granted");
        this.event.detail("code_id", userSession.getId());
        this.event.session(userSession.getId());
        this.event.user(user);
        logger.debugf("Successfully verified Authe Req Id '%s'. User session: '%s', client: '%s'", (Object)request, (Object)userSession.getId(), (Object)this.client.getId());
        return userSession;
    }

    private static void logDebug(String message, CIBAAuthenticationRequest request) {
        logger.debugf("CIBA Grant :: authentication channel %s clientId = %s, authResultId = %s", (Object)message, (Object)request.getIssuedFor(), (Object)request.getAuthResultId());
    }
}

