/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authSession;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntity;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodRootAuthenticationSessionEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;

public class HotRodRootAuthenticationSessionEntityDelegate
extends HotRodRootAuthenticationSessionEntity.AbstractHotRodRootAuthenticationSessionEntityDelegate
implements MapRootAuthenticationSessionEntity {
    private final HotRodRootAuthenticationSessionEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodRootAuthenticationSessionEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodRootAuthenticationSessionEntity();
    }

    public HotRodRootAuthenticationSessionEntityDelegate(HotRodRootAuthenticationSessionEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodRootAuthenticationSessionEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodRootAuthenticationSessionEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodRootAuthenticationSessionEntityDelegate)) {
            return false;
        }
        HotRodRootAuthenticationSessionEntityDelegate other = (HotRodRootAuthenticationSessionEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAuthenticationSessions(), other.getAuthenticationSessions()) && Objects.equals(this.getExpiration(), other.getExpiration()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getTimestamp(), other.getTimestamp());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodRootAuthenticationSessionEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodRootAuthenticationSessionEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodRootAuthenticationSessionEntity e1 = (HotRodRootAuthenticationSessionEntity)o1;
        HotRodRootAuthenticationSessionEntity e2 = (HotRodRootAuthenticationSessionEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.timestamp, e2.timestamp) && Objects.equals(e1.expiration, e2.expiration) && Objects.equals(e1.authenticationSessions, e2.authenticationSessions);
    }

    public static int entityHashCode(HotRodRootAuthenticationSessionEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public Set<MapAuthenticationSessionEntity> getAuthenticationSessions() {
        return this.hotRodEntity.authenticationSessions == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.authenticationSessions, collectionItem -> new HotRodAuthenticationSessionEntityDelegate((HotRodAuthenticationSessionEntity)collectionItem));
    }

    public void setAuthenticationSessions(Set<MapAuthenticationSessionEntity> p0) {
        Set<MapAuthenticationSessionEntity> set = p0 = p0 == null ? null : (Set<MapAuthenticationSessionEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAuthenticationSessionEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateSet(p0, collectionItem -> (HotRodAuthenticationSessionEntity)((HotRodEntityDelegate)collectionItem).getHotRodEntity());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authenticationSessions, migrated);
        this.hotRodEntity.authenticationSessions = migrated;
    }

    public void addAuthenticationSession(MapAuthenticationSessionEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.authenticationSessions == null) {
            this.hotRodEntity.authenticationSessions = new HashSet<HotRodAuthenticationSessionEntity>();
        }
        HotRodAuthenticationSessionEntity migrated = (HotRodAuthenticationSessionEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.authenticationSessions.add(migrated);
    }

    public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String p0) {
        if (this.hotRodEntity.authenticationSessions == null || this.hotRodEntity.authenticationSessions.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.authenticationSessions.stream().filter(o -> Objects.equals(o.tabId, p0)).findFirst().map(e -> new HotRodAuthenticationSessionEntityDelegate((HotRodAuthenticationSessionEntity)e));
    }

    public Boolean removeAuthenticationSession(String p0) {
        boolean removed = this.hotRodEntity.authenticationSessions != null && this.hotRodEntity.authenticationSessions.removeIf(o -> Objects.equals(o.tabId, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setExpiration(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.expiration, migrated);
        this.hotRodEntity.expiration = migrated;
    }

    public Long getExpiration() {
        return this.hotRodEntity.expiration == null ? null : this.hotRodEntity.expiration;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public Long getTimestamp() {
        return this.hotRodEntity.timestamp == null ? null : this.hotRodEntity.timestamp;
    }

    public void setTimestamp(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.timestamp, migrated);
        this.hotRodEntity.timestamp = migrated;
    }

    @Override
    public HotRodRootAuthenticationSessionEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

