/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.userSession;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;

public class HotRodAuthenticatedClientSessionEntityDelegate
extends HotRodAuthenticatedClientSessionEntity.AbstractHotRodAuthenticatedClientSessionEntityDelegate
implements MapAuthenticatedClientSessionEntity {
    private final HotRodAuthenticatedClientSessionEntity hotRodEntity;

    public HotRodAuthenticatedClientSessionEntityDelegate() {
        this.hotRodEntity = new HotRodAuthenticatedClientSessionEntity();
    }

    public HotRodAuthenticatedClientSessionEntityDelegate(HotRodAuthenticatedClientSessionEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodAuthenticatedClientSessionEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodAuthenticatedClientSessionEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodAuthenticatedClientSessionEntityDelegate)) {
            return false;
        }
        HotRodAuthenticatedClientSessionEntityDelegate other = (HotRodAuthenticatedClientSessionEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAction(), other.getAction()) && Objects.equals(this.getAuthMethod(), other.getAuthMethod()) && Objects.equals(this.getClientId(), other.getClientId()) && Objects.equals(this.getCurrentRefreshToken(), other.getCurrentRefreshToken()) && Objects.equals(this.getCurrentRefreshTokenUseCount(), other.getCurrentRefreshTokenUseCount()) && Objects.equals(this.getExpiration(), other.getExpiration()) && Objects.equals(this.getNotes(), other.getNotes()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getRedirectUri(), other.getRedirectUri()) && Objects.equals(this.getTimestamp(), other.getTimestamp()) && Objects.equals(this.isOffline(), other.isOffline());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodAuthenticatedClientSessionEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodAuthenticatedClientSessionEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodAuthenticatedClientSessionEntity e1 = (HotRodAuthenticatedClientSessionEntity)o1;
        HotRodAuthenticatedClientSessionEntity e2 = (HotRodAuthenticatedClientSessionEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.clientId, e2.clientId) && Objects.equals(e1.authMethod, e2.authMethod) && Objects.equals(e1.redirectUri, e2.redirectUri) && Objects.equals(e1.timestamp, e2.timestamp) && Objects.equals(e1.expiration, e2.expiration) && Objects.equals(e1.action, e2.action) && Objects.equals(e1.notes, e2.notes) && Objects.equals(e1.currentRefreshToken, e2.currentRefreshToken) && Objects.equals(e1.currentRefreshTokenUseCount, e2.currentRefreshTokenUseCount) && Objects.equals(e1.offline, e2.offline);
    }

    public static int entityHashCode(HotRodAuthenticatedClientSessionEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public String getId() {
        return this.hotRodEntity.id == null ? null : this.hotRodEntity.id;
    }

    public String getAction() {
        return this.hotRodEntity.action == null ? null : this.hotRodEntity.action;
    }

    public void setAction(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.action, migrated);
        this.hotRodEntity.action = migrated;
    }

    public String getAuthMethod() {
        return this.hotRodEntity.authMethod == null ? null : this.hotRodEntity.authMethod;
    }

    public void setAuthMethod(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authMethod, migrated);
        this.hotRodEntity.authMethod = migrated;
    }

    public String getClientId() {
        return this.hotRodEntity.clientId == null ? null : this.hotRodEntity.clientId;
    }

    public void setCurrentRefreshToken(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.currentRefreshToken, migrated);
        this.hotRodEntity.currentRefreshToken = migrated;
    }

    public String getCurrentRefreshToken() {
        return this.hotRodEntity.currentRefreshToken == null ? null : this.hotRodEntity.currentRefreshToken;
    }

    public Integer getCurrentRefreshTokenUseCount() {
        return this.hotRodEntity.currentRefreshTokenUseCount == null ? null : this.hotRodEntity.currentRefreshTokenUseCount;
    }

    public void setCurrentRefreshTokenUseCount(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.currentRefreshTokenUseCount, migrated);
        this.hotRodEntity.currentRefreshTokenUseCount = migrated;
    }

    public void setExpiration(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.expiration, migrated);
        this.hotRodEntity.expiration = migrated;
    }

    public Long getExpiration() {
        return this.hotRodEntity.expiration == null ? null : this.hotRodEntity.expiration;
    }

    public Boolean removeNote(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notes, migrated);
        this.hotRodEntity.notes = migrated;
    }

    public String getNote(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, String> getNotes() {
        return this.hotRodEntity.notes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.notes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.notes == null && !valueUndefined) {
            this.hotRodEntity.notes = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.notes.add(new HotRodPair<String, String>(p0, p1)));
    }

    public void setOffline(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.offline, migrated);
        this.hotRodEntity.offline = migrated;
    }

    public Boolean isOffline() {
        return this.hotRodEntity.offline == null ? null : this.hotRodEntity.offline;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public String getRedirectUri() {
        return this.hotRodEntity.redirectUri == null ? null : this.hotRodEntity.redirectUri;
    }

    public void setRedirectUri(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.redirectUri, migrated);
        this.hotRodEntity.redirectUri = migrated;
    }

    public Long getTimestamp() {
        return this.hotRodEntity.timestamp == null ? null : this.hotRodEntity.timestamp;
    }

    public void setTimestamp(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.timestamp, migrated);
        this.hotRodEntity.timestamp = migrated;
    }

    @Override
    public HotRodAuthenticatedClientSessionEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

