/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.realm.MapRealmAdapter;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.storage.SearchableModelField;

public class MapRealmProvider
implements RealmProvider {
    private static final Logger LOG = Logger.getLogger(MapRealmProvider.class);
    private final KeycloakSession session;
    final MapStorage<MapRealmEntity, RealmModel> store;

    public MapRealmProvider(KeycloakSession session, MapStorage<MapRealmEntity, RealmModel> realmStore) {
        this.session = session;
        this.store = realmStore;
    }

    private RealmModel entityToAdapter(MapRealmEntity entity) {
        return new MapRealmAdapter(this.session, entity);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        if (this.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm with given name exists: " + name);
        }
        if (id != null && this.store.exists(id)) {
            throw new ModelDuplicateException("Realm exists: " + id);
        }
        LOG.tracef("createRealm(%s, %s)%s", (Object)id, (Object)name, StackUtil.getShortStackTrace());
        MapRealmEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapRealmEntity.class);
        entity.setId(id);
        entity.setName(name);
        entity = this.store.create(entity);
        return this.entityToAdapter(entity);
    }

    public RealmModel getRealm(String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        MapRealmEntity entity = this.store.read(id);
        return entity == null ? null : this.entityToAdapter(entity);
    }

    public RealmModel getRealmByName(String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmByName(%s)%s", (Object)name, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        String realmId = this.store.read(QueryParameters.withCriteria(mcb)).findFirst().map(AbstractEntity::getId).orElse(null);
        return realmId == null ? null : this.session.realms().getRealm(realmId);
    }

    public Stream<RealmModel> getRealmsStream() {
        return this.getRealmsStream(DefaultModelCriteria.criteria());
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> type) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.COMPONENT_PROVIDER_TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type.getName()});
        return this.getRealmsStream(mcb);
    }

    private Stream<RealmModel> getRealmsStream(DefaultModelCriteria<RealmModel> mcb) {
        return this.store.read(QueryParameters.withCriteria(mcb).orderBy((SearchableModelField<RealmModel>)RealmModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this::entityToAdapter);
    }

    public boolean removeRealm(String id) {
        LOG.tracef("removeRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE, new Object[]{realm});
        this.store.delete(id);
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.REALM_AFTER_REMOVE, new Object[]{realm});
        return true;
    }

    public void removeExpiredClientInitialAccess() {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.CLIENT_INITIAL_ACCESS, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
        this.store.read(QueryParameters.withCriteria(mcb)).forEach(MapRealmEntity::removeExpiredClientInitialAccesses);
    }

    public void saveLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (locale == null || key == null || text == null) {
            return;
        }
        HashMap<String, String> texts = new HashMap<String, String>();
        texts.put(key, text);
        realm.createOrUpdateRealmLocalizationTexts(locale, texts);
    }

    public void saveLocalizationTexts(RealmModel realm, String locale, Map<String, String> localizationTexts) {
        if (locale == null || localizationTexts == null) {
            return;
        }
        realm.createOrUpdateRealmLocalizationTexts(locale, localizationTexts);
    }

    public boolean updateLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (locale == null || key == null || text == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        this.saveLocalizationText(realm, locale, key, text);
        return true;
    }

    public boolean deleteLocalizationTextsByLocale(RealmModel realm, String locale) {
        return realm.removeRealmLocalizationTexts(locale);
    }

    public boolean deleteLocalizationText(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        HashMap texts = new HashMap(realm.getRealmLocalizationTextsByLocale(locale));
        texts.remove(key);
        realm.removeRealmLocalizationTexts(locale);
        realm.createOrUpdateRealmLocalizationTexts(locale, texts);
        return true;
    }

    public String getLocalizationTextsById(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return null;
        }
        return (String)realm.getRealmLocalizationTextsByLocale(locale).get(key);
    }

    public void close() {
    }
}

