/*
 * Decompiled with CFR 0.152.
 */
package de.itrupp.p8.keycloak.authenticator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.JsonSerialization;

public class RegistrationhCaptcha
implements FormAction,
FormActionFactory {
    public static final String H_CAPTCHA_RESPONSE = "h-captcha-response";
    public static final String HCAPTCHA_REFERENCE_CATEGORY = "hcaptcha";
    public static final String SITE_KEY = "site.key";
    public static final String SITE_SECRET = "secret";
    public static final String PROVIDER_ID = "registration-hcaptcha-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public void close() {
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "hCaptcha";
    }

    public String getReferenceCategory() {
        return HCAPTCHA_REFERENCE_CATEGORY;
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Adds hCaptcha button.  hCaptchas verify that the entity that is registering is a human.  This can only be used on the internet and must be configured after you add it.";
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        AuthenticatorConfigModel captchaConfig = context.getAuthenticatorConfig();
        String userLanguageTag = context.getSession().getContext().resolveLocale(context.getUser()).toLanguageTag();
        if (captchaConfig == null || captchaConfig.getConfig() == null || captchaConfig.getConfig().get(SITE_KEY) == null || captchaConfig.getConfig().get(SITE_SECRET) == null) {
            form.addError(new FormMessage(null, "recaptchaNotConfigured"));
            return;
        }
        String siteKey = (String)captchaConfig.getConfig().get(SITE_KEY);
        String compact = (String)captchaConfig.getConfig().get("compact");
        form.setAttribute("hcaptchaRequired", (Object)true);
        form.setAttribute("hcaptchaCompact", (Object)compact);
        form.setAttribute("hcaptchaSiteKey", (Object)siteKey);
        form.addScript("https://js.hcaptcha.com/1/api.js?hl=" + userLanguageTag);
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        boolean success = false;
        context.getEvent().detail("register_method", "form");
        String captcha = (String)formData.getFirst((Object)H_CAPTCHA_RESPONSE);
        if (!Validation.isBlank((String)captcha)) {
            AuthenticatorConfigModel captchaConfig = context.getAuthenticatorConfig();
            String secret = (String)captchaConfig.getConfig().get(SITE_SECRET);
            success = this.validateRecaptcha(context, success, captcha, secret);
        }
        if (!success) {
            errors.add(new FormMessage(null, "recaptchaFailed"));
            formData.remove((Object)H_CAPTCHA_RESPONSE);
            context.error("invalid_registration");
            context.validationError(formData, errors);
            context.excludeOtherErrors();
            return;
        }
        context.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateRecaptcha(ValidationContext context, boolean success, String captcha, String secret) {
        CloseableHttpClient httpClient = ((HttpClientProvider)context.getSession().getProvider(HttpClientProvider.class)).getHttpClient();
        HttpPost post = new HttpPost("https://hcaptcha.com/siteverify");
        LinkedList<BasicNameValuePair> formparams = new LinkedList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair(SITE_SECRET, secret));
        formparams.add(new BasicNameValuePair("response", captcha));
        formparams.add(new BasicNameValuePair("remoteip", context.getConnection().getRemoteAddr()));
        try {
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
            post.setEntity((HttpEntity)form);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                InputStream content = response.getEntity().getContent();
                try {
                    Map json = (Map)JsonSerialization.readValue((InputStream)content, Map.class);
                    Object val = json.get("success");
                    success = Boolean.TRUE.equals(val);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.recaptchaFailed(e);
        }
        return success;
    }

    public void success(FormContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(SITE_KEY);
        property.setLabel("hCaptcha Site Key");
        property.setType("String");
        property.setHelpText("hCaptcha Site Key");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(SITE_SECRET);
        property.setLabel("hCaptcha Secret");
        property.setType("String");
        property.setHelpText("hCaptcha Secret");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName("compact");
        property.setLabel("hCaptcha Compact");
        property.setType("boolean");
        property.setHelpText("Compact format");
        CONFIG_PROPERTIES.add(property);
    }
}

