/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.jboss.logging.Logger;

class ResourceExtractor {
    private static final Logger logger = Logger.getLogger(ResourceExtractor.class);
    private static final boolean IS_RESOURCE_SCRAPING_DISABLED = Boolean.getBoolean("RESOURCE_SCRAPING_DISABLED");
    private static final boolean URI_METRICS_ENABLED = Boolean.parseBoolean(System.getenv("URI_METRICS_ENABLED"));
    private static final boolean URI_METRICS_DETAILED = Boolean.parseBoolean(System.getenv("URI_METRICS_DETAILED"));
    private static final String URI_METRICS_FILTER = System.getenv("URI_METRICS_FILTER");

    private ResourceExtractor() {
    }

    static String getResource(UriInfo uriInfo) {
        List matchedURIs;
        if (!IS_RESOURCE_SCRAPING_DISABLED && (matchedURIs = uriInfo.getMatchedURIs()).size() >= 2) {
            if ("resources".equals(matchedURIs.get(matchedURIs.size() - 1))) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append((String)matchedURIs.get(matchedURIs.size() - 1));
            sb.append(",");
            sb.append((String)matchedURIs.get(matchedURIs.size() - 2));
            return sb.toString();
        }
        return "";
    }

    static String getURI(UriInfo uriInfo) {
        if (URI_METRICS_ENABLED) {
            List matchedURIs = uriInfo.getMatchedURIs();
            StringBuilder sb = new StringBuilder();
            if (URI_METRICS_FILTER != null && URI_METRICS_FILTER.length() != 0) {
                String[] filter = URI_METRICS_FILTER.split(",");
                for (int i = 0; i < filter.length; ++i) {
                    if (!((String)matchedURIs.get(0)).contains(filter[i])) continue;
                    sb = ResourceExtractor.getURIDetailed(sb, matchedURIs);
                }
            } else {
                sb = ResourceExtractor.getURIDetailed(sb, matchedURIs);
            }
            return sb.toString();
        }
        return "";
    }

    private static StringBuilder getURIDetailed(StringBuilder sb, List<String> matchedURIs) {
        String uri = matchedURIs.get(0);
        if (URI_METRICS_DETAILED) {
            sb.append(uri);
        } else {
            String[] realm = uri.split("/");
            if (realm.length != 1) {
                if (uri.startsWith("admin/realms/")) {
                    uri = uri.replace(realm[2], "{realm}");
                    if (realm.length > 4 && realm[3].equals("clients")) {
                        uri = uri.replace(realm[4], "{id}");
                    }
                }
                if (uri.startsWith("realms/")) {
                    uri = uri.replace(realm[1], "{realm}");
                }
            }
            sb.append(uri);
        }
        return sb;
    }
}

