/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJCompressor
implements Closeable {
    private long handle = 0L;
    private byte[] srcBuf8 = null;
    private short[] srcBuf12 = null;
    private short[] srcBuf16 = null;
    private int[] srcBufInt = null;
    private int srcWidth = 0;
    private int srcHeight = 0;
    private int srcX = -1;
    private int srcY = -1;
    private int srcPitch = 0;
    private int srcStride = 0;
    private int srcPixelFormat = -1;
    private YUVImage srcYUVImage = null;
    private int compressedSize = 0;
    private ByteOrder byteOrder = null;

    public TJCompressor() throws TJException {
        this.init();
    }

    public TJCompressor(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        this.setSourceImage(byArray, n, n2, n3, n4, n5, n6);
    }

    public TJCompressor(BufferedImage bufferedImage, int n, int n2, int n3, int n4) throws TJException {
        this.setSourceImage(bufferedImage, n, n2, n3, n4);
    }

    public void setSourceImage(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (byArray == null || n < 0 || n2 < 0 || n3 < 1 || n5 < 1 || n4 < 0 || n6 < 0 || n6 >= 12) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcBuf8 = byArray;
        this.srcWidth = n3;
        this.srcPitch = n4 == 0 ? n3 * TJ.getPixelSize(n6) : n4;
        this.srcHeight = n5;
        this.srcPixelFormat = n6;
        this.srcX = n;
        this.srcY = n2;
        this.srcBuf12 = null;
        this.srcBuf16 = null;
        this.srcBufInt = null;
        this.srcYUVImage = null;
    }

    public void setSourceImage12(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (sArray == null || n < 0 || n2 < 0 || n3 < 1 || n5 < 1 || n4 < 0 || n6 < 0 || n6 >= 12) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcBuf12 = sArray;
        this.srcWidth = n3;
        this.srcPitch = n4 == 0 ? n3 * TJ.getPixelSize(n6) : n4;
        this.srcHeight = n5;
        this.srcPixelFormat = n6;
        this.srcX = n;
        this.srcY = n2;
        this.srcBuf8 = null;
        this.srcBuf16 = null;
        this.srcBufInt = null;
        this.srcYUVImage = null;
    }

    public void setSourceImage16(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (sArray == null || n < 0 || n2 < 0 || n3 < 1 || n5 < 1 || n4 < 0 || n6 < 0 || n6 >= 12) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcBuf16 = sArray;
        this.srcWidth = n3;
        this.srcPitch = n4 == 0 ? n3 * TJ.getPixelSize(n6) : n4;
        this.srcHeight = n5;
        this.srcPixelFormat = n6;
        this.srcX = n;
        this.srcY = n2;
        this.srcBuf8 = null;
        this.srcBuf12 = null;
        this.srcBufInt = null;
        this.srcYUVImage = null;
    }

    public void setSourceImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) throws TJException {
        int n5;
        if (this.handle == 0L) {
            this.init();
        }
        if (bufferedImage == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcX = n;
        this.srcY = n2;
        this.srcWidth = n3 == 0 ? bufferedImage.getWidth() : n3;
        int n6 = this.srcHeight = n4 == 0 ? bufferedImage.getHeight() : n4;
        if (n + n3 > bufferedImage.getWidth() || n2 + n4 > bufferedImage.getHeight()) {
            throw new IllegalArgumentException("Compression region exceeds the bounds of the source image");
        }
        boolean bl = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (bufferedImage.getType()) {
            case 5: {
                n5 = 1;
                break;
            }
            case 6: 
            case 7: {
                n5 = 4;
                break;
            }
            case 10: {
                n5 = 6;
                break;
            }
            case 4: {
                n5 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n5 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        this.srcPixelFormat = n5;
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bl) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            this.srcStride = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.srcBufInt = dataBufferInt.getData();
            this.srcBuf8 = null;
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n7 = componentSampleModel.getPixelStride();
            if (n7 != TJ.getPixelSize(n5)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            this.srcPitch = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            this.srcBuf8 = dataBufferByte.getData();
            this.srcBufInt = null;
        }
        this.srcYUVImage = null;
    }

    public void setSourceImage(YUVImage yUVImage) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcYUVImage = yUVImage;
        this.set(4, yUVImage.getSubsamp());
        this.srcBuf8 = null;
        this.srcBufInt = null;
    }

    public native void set(int var1, int var2);

    public native int get(int var1);

    @Deprecated
    public void setSubsamp(int n) {
        if (n < 0 || n >= 7) {
            throw new IllegalArgumentException("Invalid argument in setSubsamp()");
        }
        this.set(4, n);
    }

    @Deprecated
    public void setJPEGQuality(int n) {
        if (n < 1 || n > 100) {
            throw new IllegalArgumentException("Invalid argument in setJPEGQuality()");
        }
        this.set(3, n);
    }

    public void compress(byte[] byArray) throws TJException {
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid argument in compress()");
        }
        if (this.srcYUVImage != null) {
            this.checkSubsampling();
            if (this.get(4) != this.srcYUVImage.getSubsamp()) {
                throw new IllegalStateException("TJ.PARAM_SUBSAMP must match subsampling level of YUV image");
            }
            this.compressedSize = this.compressFromYUV8(this.srcYUVImage.getPlanes(), this.srcYUVImage.getOffsets(), this.srcYUVImage.getWidth(), this.srcYUVImage.getStrides(), this.srcYUVImage.getHeight(), byArray);
        } else if (this.srcBuf8 != null) {
            this.compressedSize = this.compress8(this.srcBuf8, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, byArray);
        } else if (this.srcBuf12 != null) {
            this.compressedSize = this.compress12(this.srcBuf12, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, byArray);
        } else if (this.srcBuf16 != null) {
            this.compressedSize = this.compress16(this.srcBuf16, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, byArray);
        } else if (this.srcBufInt != null) {
            this.compressedSize = this.compress8(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, byArray);
        } else {
            throw new IllegalStateException("No source image is associated with this instance");
        }
    }

    @Deprecated
    public void compress(byte[] byArray, int n) throws TJException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid argument in compress()");
        }
        this.processFlags(n);
        this.compress(byArray);
    }

    public byte[] compress() throws TJException {
        byte[] byArray;
        if (this.srcYUVImage != null) {
            byArray = new byte[TJ.bufSize(this.srcYUVImage.getWidth(), this.srcYUVImage.getHeight(), this.srcYUVImage.getSubsamp())];
        } else {
            this.checkSubsampling();
            int n = this.get(4);
            byArray = new byte[TJ.bufSize(this.srcWidth, this.srcHeight, n)];
        }
        this.compress(byArray);
        return byArray;
    }

    @Deprecated
    public byte[] compress(int n) throws TJException {
        this.processFlags(n);
        return this.compress();
    }

    public void encodeYUV(YUVImage yUVImage) throws TJException {
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        if (this.srcBuf8 == null && this.srcBufInt == null) {
            throw new IllegalStateException("No 8-bit-per-sample source image is associated with this instance");
        }
        if (this.srcYUVImage != null) {
            throw new IllegalStateException("Source image is not correct type");
        }
        if (this.srcWidth != yUVImage.getWidth() || this.srcHeight != yUVImage.getHeight()) {
            throw new IllegalStateException("Destination image is the wrong size");
        }
        this.set(4, yUVImage.getSubsamp());
        if (this.srcBufInt != null) {
            this.encodeYUV8(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getStrides());
        } else {
            this.encodeYUV8(this.srcBuf8, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getStrides());
        }
        this.compressedSize = 0;
    }

    @Deprecated
    public void encodeYUV(YUVImage yUVImage, int n) throws TJException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        this.processFlags(n);
        this.encodeYUV(yUVImage);
    }

    public YUVImage encodeYUV(int n) throws TJException {
        if (this.srcBuf8 == null && this.srcBufInt == null) {
            throw new IllegalStateException("No 8-bit-per-sample source image is associated with this instance");
        }
        this.checkSubsampling();
        if (n < 1 || (n & n - 1) != 0) {
            throw new IllegalStateException("Invalid argument in encodeYUV()");
        }
        YUVImage yUVImage = new YUVImage(this.srcWidth, n, this.srcHeight, this.get(4));
        this.encodeYUV(yUVImage);
        return yUVImage;
    }

    @Deprecated
    public YUVImage encodeYUV(int n, int n2) throws TJException {
        this.processFlags(n2);
        return this.encodeYUV(n);
    }

    public YUVImage encodeYUV(int[] nArray) throws TJException {
        if (this.srcBuf8 == null && this.srcBufInt == null) {
            throw new IllegalStateException("No 8-bit-per-sample source image is associated with this instance");
        }
        this.checkSubsampling();
        YUVImage yUVImage = new YUVImage(this.srcWidth, nArray, this.srcHeight, this.get(4));
        this.encodeYUV(yUVImage);
        return yUVImage;
    }

    @Deprecated
    public YUVImage encodeYUV(int[] nArray, int n) throws TJException {
        this.processFlags(n);
        return this.encodeYUV(nArray);
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public void close() throws TJException {
        if (this.handle != 0L) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    private void processFlags(int n) {
        this.set(1, (n & 2) != 0 ? 1 : 0);
        if (this.get(3) >= 96 || (n & 0x1000) != 0) {
            this.set(10, 0);
        } else {
            this.set(10, 1);
        }
        this.set(0, (n & 0x2000) != 0 ? 1 : 0);
        this.set(12, (n & 0x4000) != 0 ? 1 : 0);
    }

    private void checkSubsampling() {
        if (this.get(4) == -1) {
            throw new IllegalStateException("TJ.PARAM_SUBSAMP must be specified");
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    private native int compress8(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8) throws TJException;

    private native int compress12(short[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8) throws TJException;

    private native int compress16(short[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8) throws TJException;

    private native int compress8(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8) throws TJException;

    private native int compressFromYUV8(byte[][] var1, int[] var2, int var3, int[] var4, int var5, byte[] var6) throws TJException;

    private native void encodeYUV8(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10) throws TJException;

    private native void encodeYUV8(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10) throws TJException;

    public native Object loadImage(int var1, String var2, int[] var3, int var4, int[] var5, int[] var6) throws TJException;

    static {
        TJLoader.load();
    }
}

