/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJ;

public class YUVImage {
    private static final String NO_ASSOC_ERROR = "No image data is associated with this instance";
    private long handle = 0L;
    private byte[][] yuvPlanes = null;
    private int[] yuvOffsets = null;
    private int[] yuvStrides = null;
    private int yuvAlign = 1;
    private int yuvWidth = 0;
    private int yuvHeight = 0;
    private int yuvSubsamp = -1;

    public YUVImage(int n, int[] nArray, int n2, int n3) {
        this.setBuf(null, null, n, nArray, n2, n3, true);
    }

    public YUVImage(int n, int n2, int n3, int n4) {
        this.setBuf(new byte[TJ.bufSizeYUV(n, n2, n3, n4)], n, n2, n3, n4);
    }

    public YUVImage(byte[][] byArray, int[] nArray, int n, int[] nArray2, int n2, int n3) {
        this.setBuf(byArray, nArray, n, nArray2, n2, n3, false);
    }

    public YUVImage(byte[] byArray, int n, int n2, int n3, int n4) {
        this.setBuf(byArray, n, n2, n3, n4);
    }

    public void setBuf(byte[][] byArray, int[] nArray, int n, int[] nArray2, int n2, int n3) {
        this.setBuf(byArray, nArray, n, nArray2, n2, n3, false);
    }

    private void setBuf(byte[][] object, int[] nArray, int n, int[] nArray2, int n2, int n3, boolean bl) {
        int n4;
        if (object == null && !bl || n < 1 || n2 < 1 || n3 < 0 || n3 >= 7) {
            throw new IllegalArgumentException("Invalid argument in YUVImage::setBuf()");
        }
        int n5 = n4 = n3 == 3 ? 1 : 3;
        if (object != null && ((byte[][])object).length != n4 || nArray != null && nArray.length != n4 || nArray2 != null && nArray2.length != n4) {
            throw new IllegalArgumentException("YUVImage::setBuf(): planes, offsets, or strides array is the wrong size");
        }
        if (object == null) {
            object = new byte[n4][];
        }
        if (nArray == null) {
            nArray = new int[n4];
        }
        if (nArray2 == null) {
            nArray2 = new int[n4];
        }
        for (int i = 0; i < n4; ++i) {
            int n6 = TJ.planeWidth(i, n, n3);
            int n7 = TJ.planeHeight(i, n2, n3);
            int n8 = TJ.planeSizeYUV(i, n, nArray2[i], n2, n3);
            if (nArray2[i] == 0) {
                nArray2[i] = n6;
            }
            if (bl) {
                if (nArray2[i] < n6) {
                    throw new IllegalArgumentException("Stride must be >= plane width when allocating a new YUV image");
                }
                object[i] = new byte[nArray2[i] * n7];
            }
            if (object[i] == null || nArray[i] < 0) {
                throw new IllegalArgumentException("Invalid argument in YUVImage::setBuf()");
            }
            if (nArray2[i] < 0 && nArray[i] - n8 + n6 < 0) {
                throw new IllegalArgumentException("Stride for plane " + i + " would cause memory to be accessed below plane boundary");
            }
            if (object[i].length >= nArray[i] + n8) continue;
            throw new IllegalArgumentException("Image plane " + i + " is not large enough");
        }
        this.yuvPlanes = object;
        this.yuvOffsets = nArray;
        this.yuvWidth = n;
        this.yuvStrides = nArray2;
        this.yuvHeight = n2;
        this.yuvSubsamp = n3;
    }

    public void setBuf(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray == null || n < 1 || n2 < 1 || (n2 & n2 - 1) != 0 || n3 < 1 || n4 < 0 || n4 >= 7) {
            throw new IllegalArgumentException("Invalid argument in YUVImage::setBuf()");
        }
        if (byArray.length < TJ.bufSizeYUV(n, n2, n3, n4)) {
            throw new IllegalArgumentException("YUV buffer is not large enough");
        }
        int n5 = n4 == 3 ? 1 : 3;
        byte[][] byArrayArray = new byte[n5][];
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        byArrayArray[0] = byArray;
        nArray[0] = YUVImage.pad(TJ.planeWidth(0, n, n4), n2);
        if (n4 != 3) {
            nArray[1] = nArray[2] = YUVImage.pad(TJ.planeWidth(1, n, n4), n2);
            byArrayArray[2] = byArray;
            byArrayArray[1] = byArray;
            nArray2[1] = nArray2[0] + nArray[0] * TJ.planeHeight(0, n3, n4);
            nArray2[2] = nArray2[1] + nArray[1] * TJ.planeHeight(1, n3, n4);
        }
        this.yuvAlign = n2;
        this.setBuf(byArrayArray, nArray2, n, nArray, n3, n4);
    }

    public int getWidth() {
        if (this.yuvWidth < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvWidth;
    }

    public int getHeight() {
        if (this.yuvHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvHeight;
    }

    public int getPad() {
        if (this.yuvPlanes == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.yuvAlign < 1 || (this.yuvAlign & this.yuvAlign - 1) != 0) {
            throw new IllegalStateException("Image is not stored in a unified buffer");
        }
        return this.yuvAlign;
    }

    public int[] getStrides() {
        if (this.yuvStrides == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvStrides;
    }

    public int[] getOffsets() {
        if (this.yuvOffsets == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvOffsets;
    }

    public int getSubsamp() {
        if (this.yuvSubsamp < 0 || this.yuvSubsamp >= 7) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvSubsamp;
    }

    public byte[][] getPlanes() {
        if (this.yuvPlanes == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.yuvPlanes;
    }

    public byte[] getBuf() {
        if (this.yuvPlanes == null || this.yuvSubsamp < 0 || this.yuvSubsamp >= 7) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        int n = this.yuvSubsamp == 3 ? 1 : 3;
        for (int i = 1; i < n; ++i) {
            if (this.yuvPlanes[i] == this.yuvPlanes[0]) continue;
            throw new IllegalStateException("Image is not stored in a unified buffer");
        }
        return this.yuvPlanes[0];
    }

    public int getSize() {
        int n;
        if (this.yuvPlanes == null || this.yuvSubsamp < 0 || this.yuvSubsamp >= 7) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        int n2 = n = this.yuvSubsamp == 3 ? 1 : 3;
        if (this.yuvAlign < 1) {
            throw new IllegalStateException("Image is not stored in a unified buffer");
        }
        for (int i = 1; i < n; ++i) {
            if (this.yuvPlanes[i] == this.yuvPlanes[0]) continue;
            throw new IllegalStateException("Image is not stored in a unified buffer");
        }
        return TJ.bufSizeYUV(this.yuvWidth, this.yuvAlign, this.yuvHeight, this.yuvSubsamp);
    }

    private static int pad(int n, int n2) {
        return n + n2 - 1 & ~(n2 - 1);
    }
}

