module Msf::Exploit::Remote::Kerberos::Ticket::Storage
  # A mixin providing the ability to read previously stored tickets.
  module ReadMixin
    # (see Base#load_credential)
    def load_credential(options = {})
      return nil unless active_db?

      now = Time.now.utc
      tickets(options) do |ticket|
        next if ticket.expired?(now)

        return ticket.ccache.credentials.first
      end

      nil
    end

    # (see Base#tickets)
    def tickets(options = {}, &block)
      objects(options).map do |stored_loot|
        stored_ticket = StoredTicket.new(stored_loot)
        block.call(stored_ticket) if block_given?
        stored_ticket
      end
    end
  end
end
