"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["src_CardSelector_vue"],{48961:(t,e,n)=>{n.d(e,{Z:()=>l});var o=n(87537),r=n.n(o),a=n(23645),s=n.n(a)()(r());s.push([t.id,"\n#modal-inner[data-v-e232cea0] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-e232cea0] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-e232cea0] {\n\tmin-height: 100px;\n}\nli[data-v-e232cea0] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-e232cea0]:hover, li[data-v-e232cea0]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-e232cea0] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-e232cea0] {\n\tfloat: right;\n}\n.card-selector[data-v-e232cea0] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AAgLA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<NcModal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<NcMultiselect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@select=\"fetchCardsFromBoard\">\n\t\t\t\t<template slot=\"singleLabel\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template slot=\"option\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</NcMultiselect>\n\n\t\t\t<NcMultiselect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { NcModal, NcMultiselect } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t\tNcMultiselect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector:deep(.modal-container) {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},4761:(e,n,o)=>{o.r(n),o.d(n,{default:()=>w});var r=o(79753),a=o(15961),s=o(26937);function l(t){return function(t){if(Array.isArray(t))return c(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return c(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return c(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function c(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}function i(t,e,n,o,r,a,s){try{var l=t[a](s),c=l.value}catch(t){return void n(t)}l.done?e(c):Promise.resolve(c).then(o,r)}const d={name:"CardSelector",components:{NcModal:a.Jc,NcMultiselect:a.Z2},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:function(){return{boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}},computed:{isBoardAndStackChoosen:function(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount:function(){this.fetchBoards()},methods:{fetchBoards:function(){var t=this;s.Z.get((0,r.generateUrl)("/apps/deck/boards")).then((function(e){t.boards=e.data,t.loading=!1}))},fetchCardsFromBoard:function(t){var e,n=this;return(e=regeneratorRuntime.mark((function e(){var o;return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,n.cardsFromBoard=[],o=(0,r.generateUrl)("/apps/deck/stacks/"+t.id),e.next=5,s.Z.get(o);case 5:e.sent.data.forEach((function(t){var e;(e=n.cardsFromBoard).push.apply(e,l(t.cards))})),e.next=12;break;case 9:return e.prev=9,e.t0=e.catch(0),e.abrupt("return",e.t0);case 12:case"end":return e.stop()}}),e,null,[[0,9]])})),function(){var t=this,n=arguments;return new Promise((function(o,r){var a=e.apply(t,n);function s(t){i(a,o,r,s,l,"next",t)}function l(t){i(a,o,r,s,l,"throw",t)}s(void 0)}))})()},close:function(){this.$root.$emit("close")},select:function(){this.$root.$emit("select",this.selectedCard.id)}}};var u=o(93379),p=o.n(u),A=o(7795),h=o.n(A),b=o(90569),f=o.n(b),m=o(3565),C=o.n(m),g=o(19216),v=o.n(g),k=o(44589),y=o.n(k),B=o(48961),x={};x.styleTagTransform=y(),x.setAttributes=C(),x.insert=f().bind(null,"head"),x.domAPI=h(),x.insertStyleElement=v();p()(B.Z,x);B.Z&&B.Z.locals&&B.Z.locals;const w=(0,o(51900).Z)(d,(function(){var t=this,e=t._self._c;return e("NcModal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("NcMultiselect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{select:t.fetchCardsFromBoard},scopedSlots:t._u([{key:"singleLabel",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}}]),model:{value:t.selectedBoard,callback:function(e){t.selectedBoard=e},expression:"selectedBoard"}}),t._v(" "),e("NcMultiselect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(e){t.selectedCard=e},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"e232cea0",null).exports}}]);
//# sourceMappingURL=deck-src_CardSelector_vue.js.map?v=06c2c76429ae96471d52