/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.state;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;

public class ClusterStateRequest
extends ClusterManagerNodeReadRequest<ClusterStateRequest>
implements IndicesRequest.Replaceable {
    public static final TimeValue DEFAULT_WAIT_FOR_NODE_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private boolean routingTable = true;
    private boolean nodes = true;
    private boolean metadata = true;
    private boolean blocks = true;
    private boolean customs = true;
    private Long waitForMetadataVersion;
    private TimeValue waitForTimeout = DEFAULT_WAIT_FOR_NODE_TIMEOUT;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();

    public ClusterStateRequest() {
    }

    public ClusterStateRequest(StreamInput in) throws IOException {
        super(in);
        this.routingTable = in.readBoolean();
        this.nodes = in.readBoolean();
        this.metadata = in.readBoolean();
        this.blocks = in.readBoolean();
        this.customs = in.readBoolean();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.waitForTimeout = in.readTimeValue();
        this.waitForMetadataVersion = in.readOptionalLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.routingTable);
        out.writeBoolean(this.nodes);
        out.writeBoolean(this.metadata);
        out.writeBoolean(this.blocks);
        out.writeBoolean(this.customs);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeTimeValue(this.waitForTimeout);
        out.writeOptionalLong(this.waitForMetadataVersion);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterStateRequest all() {
        this.routingTable = true;
        this.nodes = true;
        this.metadata = true;
        this.blocks = true;
        this.customs = true;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public ClusterStateRequest clear() {
        this.routingTable = false;
        this.nodes = false;
        this.metadata = false;
        this.blocks = false;
        this.customs = false;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public boolean routingTable() {
        return this.routingTable;
    }

    public ClusterStateRequest routingTable(boolean routingTable) {
        this.routingTable = routingTable;
        return this;
    }

    public boolean nodes() {
        return this.nodes;
    }

    public ClusterStateRequest nodes(boolean nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean metadata() {
        return this.metadata;
    }

    public ClusterStateRequest metadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean blocks() {
        return this.blocks;
    }

    public ClusterStateRequest blocks(boolean blocks) {
        this.blocks = blocks;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterStateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final ClusterStateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public ClusterStateRequest customs(boolean customs) {
        this.customs = customs;
        return this;
    }

    public boolean customs() {
        return this.customs;
    }

    public TimeValue waitForTimeout() {
        return this.waitForTimeout;
    }

    public ClusterStateRequest waitForTimeout(TimeValue waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
        return this;
    }

    public Long waitForMetadataVersion() {
        return this.waitForMetadataVersion;
    }

    public ClusterStateRequest waitForMetadataVersion(long waitForMetadataVersion) {
        if (waitForMetadataVersion < 1L) {
            throw new IllegalArgumentException("provided waitForMetadataVersion should be >= 1, but instead is [" + waitForMetadataVersion + "]");
        }
        this.waitForMetadataVersion = waitForMetadataVersion;
        return this;
    }
}

