/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.StoredScriptSource;

public class PutStoredScriptRequest
extends AcknowledgedRequest<PutStoredScriptRequest>
implements ToXContentFragment {
    private String id;
    private String context;
    private BytesReference content;
    private XContentType xContentType;
    private StoredScriptSource source;

    public PutStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.content = in.readBytesReference();
        this.xContentType = (XContentType)in.readEnum(XContentType.class);
        this.context = in.readOptionalString();
        this.source = new StoredScriptSource(in);
    }

    public PutStoredScriptRequest() {
    }

    public PutStoredScriptRequest(String id, String context, BytesReference content, XContentType xContentType, StoredScriptSource source) {
        this.id = id;
        this.context = context;
        this.content = content;
        this.xContentType = Objects.requireNonNull(xContentType);
        this.source = source;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError("must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id cannot contain '#' for stored script", validationException);
        }
        if (this.content == null) {
            validationException = ValidateActions.addValidationError("must specify code for stored script", validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public PutStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String context() {
        return this.context;
    }

    public PutStoredScriptRequest context(String context) {
        this.context = context;
        return this;
    }

    public BytesReference content() {
        return this.content;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public StoredScriptSource source() {
        return this.source;
    }

    public PutStoredScriptRequest content(BytesReference content, XContentType xContentType) {
        this.content = content;
        this.xContentType = Objects.requireNonNull(xContentType);
        this.source = StoredScriptSource.parse(content, xContentType);
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.content);
        out.writeEnum((Enum)this.xContentType);
        out.writeOptionalString(this.context);
        this.source.writeTo(out);
    }

    public String toString() {
        String source = "_na_";
        try {
            source = XContentHelper.convertToJson(this.content, false, (MediaType)this.xContentType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "put stored script {id [" + this.id + "]" + (String)(this.context != null ? ", context [" + this.context + "]" : "") + ", content [" + source + "]}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script");
        this.source.toXContent(builder, params);
        return builder;
    }
}

