/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.NamedDiffable;
import org.opensearch.common.io.stream.StreamInput;

public class NamedDiffableValueSerializer<T extends NamedDiffable<T>>
extends DiffableUtils.DiffableValueSerializer<String, T> {
    private final Class<T> tClass;

    public NamedDiffableValueSerializer(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public T read(StreamInput in, String key) throws IOException {
        return (T)((NamedDiffable)in.readNamedWriteable(this.tClass, key));
    }

    @Override
    public boolean supportsVersion(Diff<T> value, Version version) {
        return version.onOrAfter(((NamedDiff)value).getMinimalSupportedVersion());
    }

    @Override
    public boolean supportsVersion(T value, Version version) {
        return version.onOrAfter(value.getMinimalSupportedVersion());
    }

    @Override
    public Diff<T> readDiff(StreamInput in, String key) throws IOException {
        return (Diff)in.readNamedWriteable(NamedDiff.class, key);
    }
}

