/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fieldvisitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.util.set.Sets;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Uid;

public class FieldsVisitor
extends StoredFieldVisitor {
    private static final Set<String> BASE_REQUIRED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"_id", "_routing"}));
    private final boolean loadSource;
    private final String sourceFieldName;
    private final Set<String> requiredFields;
    protected BytesReference source;
    protected String id;
    protected Map<String, List<Object>> fieldsValues;

    public FieldsVisitor(boolean loadSource) {
        this(loadSource, "_source");
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_ignored".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public final void postProcess(Function<String, MappedFieldType> fieldTypeLookup) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = fieldTypeLookup.apply(entry.getKey());
            if (fieldType == null) {
                throw new IllegalStateException("Field [" + entry.getKey() + "] exists in the index but not in mappings");
            }
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        this.binaryField(fieldInfo, new BytesRef(value));
    }

    public void binaryField(FieldInfo fieldInfo, BytesRef value) {
        if (this.sourceFieldName.equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else if ("_id".equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value.bytes, value.offset, value.length);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) {
        assert (!"_id".equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, value);
    }

    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(fieldInfo.name, value);
    }

    public void objectField(FieldInfo fieldInfo, Object object) {
        assert (!"_id".equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, object);
    }

    public BytesReference source() {
        return this.source;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : Collections.emptyMap();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = new HashMap<String, List<Object>>();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

