/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import org.opensearch.OpenSearchException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public enum IntervalMode implements Writeable
{
    ORDERED(0),
    UNORDERED(1),
    UNORDERED_NO_OVERLAP(2);

    private final int ordinal;

    private IntervalMode(int ordinal) {
        this.ordinal = ordinal;
    }

    public static IntervalMode readFromStream(StreamInput in) throws IOException {
        int ord = in.readVInt();
        switch (ord) {
            case 0: {
                return ORDERED;
            }
            case 1: {
                return UNORDERED;
            }
            case 2: {
                return UNORDERED_NO_OVERLAP;
            }
        }
        throw new OpenSearchException("unknown serialized type [" + ord + "]", new Object[0]);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal);
    }

    public static IntervalMode fromString(String intervalMode) {
        if (intervalMode == null) {
            throw new IllegalArgumentException("cannot parse mode from null string");
        }
        for (IntervalMode mode : IntervalMode.values()) {
            if (!mode.name().equalsIgnoreCase(intervalMode)) continue;
            return mode;
        }
        throw new IllegalArgumentException("no mode can be parsed from ordinal " + intervalMode);
    }
}

