/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.CompositeIndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.VersionType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.AbstractBulkByScrollRequest;
import org.opensearch.index.reindex.AbstractBulkIndexByScrollRequest;
import org.opensearch.index.reindex.RemoteInfo;
import org.opensearch.script.Script;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.tasks.TaskId;

public class ReindexRequest
extends AbstractBulkIndexByScrollRequest<ReindexRequest>
implements CompositeIndicesRequest,
ToXContentObject {
    private IndexRequest destination;
    private RemoteInfo remoteInfo;
    static final ObjectParser<ReindexRequest, Void> PARSER = new ObjectParser("reindex");
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in reindex requests is deprecated.";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ReindexRequest.class);

    public ReindexRequest() {
        this(new SearchRequest(), new IndexRequest(), true);
    }

    ReindexRequest(SearchRequest search, IndexRequest destination) {
        this(search, destination, true);
    }

    private ReindexRequest(SearchRequest search, IndexRequest destination, boolean setDefaults) {
        super(search, setDefaults);
        this.destination = destination;
    }

    public ReindexRequest(StreamInput in) throws IOException {
        super(in);
        this.destination = new IndexRequest(in);
        this.remoteInfo = (RemoteInfo)in.readOptionalWriteable(RemoteInfo::new);
    }

    @Override
    protected ReindexRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError("use _all if you really want to copy from all existing indexes", e);
        }
        if (this.getSearchRequest().source().fetchSource() != null && !this.getSearchRequest().source().fetchSource().fetchSource()) {
            e = ValidateActions.addValidationError("_source:false is not supported in this context", e);
        }
        if (this.destination.index() == null) {
            e = ValidateActions.addValidationError("index must be specified", e);
            return e;
        }
        if (!this.routingIsValid()) {
            e = ValidateActions.addValidationError("routing must be unset, [keep], [discard] or [=<some new value>]", e);
        }
        if (this.destination.versionType() == VersionType.INTERNAL && this.destination.version() != -3L && this.destination.version() != -4L) {
            e = ValidateActions.addValidationError("unsupported version for internal versioning [" + this.destination.version() + "]", e);
        }
        if (this.getRemoteInfo() != null) {
            if (this.getSearchRequest().source().query() != null) {
                e = ValidateActions.addValidationError("reindex from remote sources should use RemoteInfo's query instead of source's query", e);
            }
            if (this.getSlices() == 0 || this.getSlices() > 1) {
                e = ValidateActions.addValidationError("reindex from remote sources doesn't support slices > 1 but was [" + this.getSlices() + "]", e);
            }
        }
        return e;
    }

    private boolean routingIsValid() {
        if (this.destination.routing() == null || this.destination.routing().startsWith("=")) {
            return true;
        }
        switch (this.destination.routing()) {
            case "keep": 
            case "discard": {
                return true;
            }
        }
        return false;
    }

    public ReindexRequest setSourceIndices(String ... sourceIndices) {
        if (sourceIndices != null) {
            this.getSearchRequest().indices(sourceIndices);
        }
        return this;
    }

    public ReindexRequest setSourceBatchSize(int size) {
        this.getSearchRequest().source().size(size);
        return this;
    }

    public ReindexRequest setSourceQuery(QueryBuilder queryBuilder) {
        if (queryBuilder != null) {
            this.getSearchRequest().source().query(queryBuilder);
        }
        return this;
    }

    @Deprecated
    public ReindexRequest addSortField(String name, SortOrder order) {
        this.getSearchRequest().source().sort(name, order);
        return this;
    }

    public ReindexRequest setDestIndex(String destIndex) {
        if (destIndex != null) {
            this.getDestination().index(destIndex);
        }
        return this;
    }

    public ReindexRequest setDestRouting(String routing) {
        this.getDestination().routing(routing);
        return this;
    }

    public ReindexRequest setDestVersionType(VersionType versionType) {
        this.getDestination().versionType(versionType);
        return this;
    }

    public void setDestPipeline(String pipelineName) {
        this.getDestination().setPipeline(pipelineName);
    }

    public ReindexRequest setDestOpType(String opType) {
        this.getDestination().opType(opType);
        return this;
    }

    public ReindexRequest setRemoteInfo(RemoteInfo remoteInfo) {
        this.remoteInfo = remoteInfo;
        return this;
    }

    public ReindexRequest setRequireAlias(boolean requireAlias) {
        this.getDestination().setRequireAlias(requireAlias);
        return this;
    }

    public IndexRequest getDestination() {
        return this.destination;
    }

    public RemoteInfo getRemoteInfo() {
        return this.remoteInfo;
    }

    @Override
    public ReindexRequest forSlice(TaskId slicingTask, SearchRequest slice, int totalSlices) {
        ReindexRequest sliced = this.doForSlice(new ReindexRequest(slice, this.destination, false), slicingTask, totalSlices);
        sliced.setRemoteInfo(this.remoteInfo);
        return sliced;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.destination.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.remoteInfo);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("reindex from ");
        if (this.remoteInfo != null) {
            b.append('[').append(this.remoteInfo).append(']');
        }
        this.searchToString(b);
        b.append(" to [").append(this.destination.index()).append(']');
        return b.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("source");
        if (this.remoteInfo != null) {
            builder.field("remote", (ToXContent)this.remoteInfo);
            builder.rawField("query", (InputStream)this.remoteInfo.getQuery().streamInput(), RemoteInfo.QUERY_CONTENT_TYPE.mediaType());
        }
        builder.array("index", this.getSearchRequest().indices());
        this.getSearchRequest().source().innerToXContent(builder, params);
        builder.endObject();
        builder.startObject("dest");
        builder.field("index", this.getDestination().index());
        if (this.getDestination().routing() != null) {
            builder.field("routing", this.getDestination().routing());
        }
        builder.field("op_type", this.getDestination().opType().getLowercase());
        if (this.getDestination().getPipeline() != null) {
            builder.field("pipeline", this.getDestination().getPipeline());
        }
        builder.field("version_type", VersionType.toString(this.getDestination().versionType()));
        builder.endObject();
        if (this.getMaxDocs() != -1) {
            builder.field("max_docs", this.getMaxDocs());
        }
        if (this.getScript() != null) {
            builder.field("script", (ToXContent)this.getScript());
        }
        if (!this.isAbortOnVersionConflict()) {
            builder.field("conflicts", "proceed");
        }
        builder.endObject();
        return builder;
    }

    public static ReindexRequest fromXContent(XContentParser parser) throws IOException {
        ReindexRequest reindexRequest = new ReindexRequest();
        PARSER.parse(parser, (Object)reindexRequest, null);
        return reindexRequest;
    }

    private static String[] extractStringArray(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toArray(new String[list.size()]);
        }
        if (value instanceof String) {
            return Strings.splitStringByCommaToArray((String)((String)value));
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a list or a string but was [" + value + "]");
    }

    static RemoteInfo buildRemoteInfo(Map<String, Object> source) throws IOException {
        URI uri;
        Map remote = (Map)source.remove("remote");
        if (remote == null) {
            return null;
        }
        String username = ReindexRequest.extractString(remote, "username");
        String password = ReindexRequest.extractString(remote, "password");
        String hostInRequest = Objects.requireNonNull(ReindexRequest.extractString(remote, "host"), "[host] must be specified to reindex from a remote cluster");
        try {
            uri = new URI(hostInRequest);
            if (uri.getPort() == -1) {
                throw new URISyntaxException(hostInRequest, "The port was not defined in the [host]");
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("[host] must be of the form [scheme]://[host]:[port](/[pathPrefix])? but was [" + hostInRequest + "]", ex);
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String pathPrefix = null;
        if (!uri.getPath().isEmpty()) {
            pathPrefix = uri.getPath();
        }
        Map<String, String> headers = ReindexRequest.extractStringStringMap(remote, "headers");
        TimeValue socketTimeout = ReindexRequest.extractTimeValue(remote, "socket_timeout", RemoteInfo.DEFAULT_SOCKET_TIMEOUT);
        TimeValue connectTimeout = ReindexRequest.extractTimeValue(remote, "connect_timeout", RemoteInfo.DEFAULT_CONNECT_TIMEOUT);
        if (!remote.isEmpty()) {
            throw new IllegalArgumentException("Unsupported fields in [remote]: [" + Strings.collectionToCommaDelimitedString(remote.keySet()) + "]");
        }
        return new RemoteInfo(scheme, host, port, pathPrefix, RemoteInfo.queryForRemote(source), username, password, headers, socketTimeout, connectTimeout);
    }

    private static String extractString(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a string but was [" + value + "]");
    }

    private static Map<String, String> extractStringStringMap(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but was [" + value + "]");
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but has [" + entry + "]");
        }
        Map safe = map;
        return safe;
    }

    private static TimeValue extractTimeValue(Map<String, Object> source, String name, TimeValue defaultValue) {
        String string = ReindexRequest.extractString(source, name);
        return string == null ? defaultValue : TimeValue.parseTimeValue((String)string, (String)name);
    }

    static void setMaxDocsValidateIdentical(AbstractBulkByScrollRequest<?> request, int maxDocs) {
        if (request.getMaxDocs() != -1 && request.getMaxDocs() != maxDocs) {
            throw new IllegalArgumentException("[max_docs] set to two different values [" + request.getMaxDocs() + "] and [" + maxDocs + "]");
        }
        request.setMaxDocs(maxDocs);
    }

    static {
        ObjectParser.Parser sourceParser = (parser, request, context) -> {
            Map source = parser.map();
            String[] indices = ReindexRequest.extractStringArray(source, "index");
            if (indices != null) {
                request.getSearchRequest().indices(indices);
            }
            request.setRemoteInfo(ReindexRequest.buildRemoteInfo(source));
            XContentBuilder builder = XContentFactory.contentBuilder((MediaType)parser.contentType());
            builder.map(source);
            try (StreamInput stream = BytesReference.bytes((XContentBuilder)builder).streamInput();
                 XContentParser innerParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)stream);){
                request.getSearchRequest().source().parseXContent(innerParser, false);
            }
        };
        ObjectParser destParser = new ObjectParser("dest");
        destParser.declareString(ReplicationRequest::index, new ParseField("index", new String[0]));
        destParser.declareString(IndexRequest::routing, new ParseField("routing", new String[0]));
        destParser.declareString(IndexRequest::opType, new ParseField("op_type", new String[0]));
        destParser.declareString(IndexRequest::setPipeline, new ParseField("pipeline", new String[0]));
        destParser.declareString((s, i) -> s.versionType(VersionType.fromString(i)), new ParseField("version_type", new String[0]));
        PARSER.declareField((arg_0, arg_1, arg_2) -> ((ObjectParser.Parser)sourceParser).parse(arg_0, arg_1, arg_2), new ParseField("source", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, v, c) -> destParser.parse(p, (Object)v.getDestination(), c), new ParseField("dest", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareInt(ReindexRequest::setMaxDocsValidateIdentical, new ParseField("max_docs", new String[]{"size"}));
        PARSER.declareField((p, v, c) -> v.setScript(Script.parse(p)), new ParseField("script", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString(AbstractBulkByScrollRequest::setConflicts, new ParseField("conflicts", new String[0]));
    }
}

