/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.Index;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.cluster.IndicesClusterStateService;

public interface IndexEventListener {
    default public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
    }

    default public void afterIndexShardCreated(IndexShard indexShard) {
    }

    default public void afterIndexShardStarted(IndexShard indexShard) {
    }

    default public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
    }

    default public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
    }

    default public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
    }

    default public void beforeIndexCreated(Index index, Settings indexSettings) {
    }

    default public void afterIndexCreated(IndexService indexService) {
    }

    default public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
    }

    default public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
    }

    default public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
    }

    default public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
    }

    default public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
    }

    default public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
    }

    default public void onStoreCreated(ShardId shardId) {
    }

    default public void onStoreClosed(ShardId shardId) {
    }

    default public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings) {
    }
}

