/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogFactory;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteBlobStoreInternalTranslogFactory
implements TranslogFactory {
    private final Repository repository;
    private final ThreadPool threadPool;

    public RemoteBlobStoreInternalTranslogFactory(Supplier<RepositoriesService> repositoriesServiceSupplier, ThreadPool threadPool, String repositoryName) {
        Repository repository;
        try {
            repository = repositoriesServiceSupplier.get().repository(repositoryName);
        }
        catch (RepositoryMissingException ex) {
            throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", (Throwable)((Object)ex));
        }
        this.repository = repository;
        this.threadPool = threadPool;
    }

    @Override
    public Translog newTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BooleanSupplier primaryModeSupplier) throws IOException {
        assert (this.repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repository;
        return new RemoteFsTranslog(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, blobStoreRepository, this.threadPool, primaryModeSupplier);
    }

    public Repository getRepository() {
        return this.repository;
    }
}

