/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.checked;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.opensearch.common.io.Channels;
import org.opensearch.common.util.concurrent.ReleasableLock;

public class TranslogCheckedContainer {
    private final Checksum checksum;
    private final AtomicLong contentLength;
    private final ReleasableLock updateLock = new ReleasableLock(new ReentrantLock());
    private final String file;

    public TranslogCheckedContainer(FileChannel channel, int offset, int len, String file) throws IOException {
        this.checksum = new CRC32();
        this.contentLength = new AtomicLong();
        this.file = file;
        byte[] bytes = Channels.readFromFileChannel(channel, (long)offset, len);
        this.updateFromBytes(bytes, 0, bytes.length);
    }

    public void updateFromBytes(byte[] bytes, int offset, int len) {
        try (ReleasableLock ignored = this.updateLock.acquire();){
            this.checksum.update(bytes, offset, len);
            this.updateContentLength(len);
        }
    }

    private void updateContentLength(long delta) {
        assert (this.updateLock.isHeldByCurrentThread());
        this.contentLength.addAndGet(delta);
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    public long getContentLength() {
        return this.contentLength.get();
    }
}

