/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryVerificationException;
import org.opensearch.repositories.VerificationFailure;
import org.opensearch.tasks.Task;
import org.opensearch.transport.EmptyTransportResponseHandler;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportService;

public class VerifyNodeRepositoryAction {
    private static final Logger logger = LogManager.getLogger(VerifyNodeRepositoryAction.class);
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    public VerifyNodeRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        transportService.registerRequestHandler(ACTION_NAME, "snapshot", VerifyNodeRepositoryRequest::new, new VerifyNodeRepositoryRequestHandler());
    }

    public void verify(final String repository, String verificationToken, final ActionListener<List<DiscoveryNode>> listener) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        DiscoveryNode localNode = discoNodes.getLocalNode();
        Collection<DiscoveryNode> masterAndDataNodes = discoNodes.getClusterManagerAndDataNodes().values();
        final ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : masterAndDataNodes) {
            if (RepositoriesService.isDedicatedVotingOnlyNode(node.getRoles())) continue;
            nodes.add(node);
        }
        final CopyOnWriteArrayList<VerificationFailure> errors = new CopyOnWriteArrayList<VerificationFailure>();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        for (final DiscoveryNode node : nodes) {
            if (node.equals(localNode)) {
                try {
                    this.doVerify(repository, verificationToken, localNode);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] failed to verify repository", (Object)repository), (Throwable)e);
                    errors.add(new VerificationFailure(node.getId(), e));
                }
                if (counter.decrementAndGet() != 0) continue;
                VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                continue;
            }
            this.transportService.sendRequest(node, ACTION_NAME, new VerifyNodeRepositoryRequest(repository, verificationToken), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    errors.add(new VerificationFailure(node.getId(), (Exception)((Object)exp)));
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                    }
                }
            });
        }
    }

    private static void finishVerification(String repositoryName, ActionListener<List<DiscoveryNode>> listener, List<DiscoveryNode> nodes, CopyOnWriteArrayList<VerificationFailure> errors) {
        if (!errors.isEmpty()) {
            listener.onFailure((Exception)((Object)new RepositoryVerificationException(repositoryName, errors.toString())));
        } else {
            listener.onResponse(nodes);
        }
    }

    private void doVerify(String repositoryName, String verificationToken, DiscoveryNode localNode) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        repository.verify(verificationToken, localNode);
    }

    class VerifyNodeRepositoryRequestHandler
    implements TransportRequestHandler<VerifyNodeRepositoryRequest> {
        VerifyNodeRepositoryRequestHandler() {
        }

        @Override
        public void messageReceived(VerifyNodeRepositoryRequest request, TransportChannel channel, Task task) throws Exception {
            DiscoveryNode localNode = VerifyNodeRepositoryAction.this.clusterService.state().nodes().getLocalNode();
            try {
                VerifyNodeRepositoryAction.this.doVerify(request.repository, request.verificationToken, localNode);
            }
            catch (Exception ex) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to verify repository", (Object)request.repository), (Throwable)ex);
                throw ex;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class VerifyNodeRepositoryRequest
    extends TransportRequest {
        private String repository;
        private String verificationToken;

        public VerifyNodeRepositoryRequest(StreamInput in) throws IOException {
            super(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        VerifyNodeRepositoryRequest(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }
    }
}

