/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.opensearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequestBuilder;
import org.opensearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.settings.SecureString;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestRequestFilter;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestBuilderListener;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler
implements RestRequestFilter {
    static final ObjectParser<NodesReloadSecureSettingsRequest, String> PARSER = new ObjectParser("reload_secure_settings", NodesReloadSecureSettingsRequest::new);
    private static final Set<String> FILTERED_FIELDS;

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_nodes/reload_secure_settings"), new RestHandler.Route(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        final NodesReloadSecureSettingsRequestBuilder nodesRequestBuilder = (NodesReloadSecureSettingsRequestBuilder)((NodesReloadSecureSettingsRequestBuilder)client.admin().cluster().prepareReloadSecureSettings().setTimeout(request.param("timeout"))).setNodesIds(nodesIds);
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> {
            if (parser != null) {
                NodesReloadSecureSettingsRequest nodesRequest = (NodesReloadSecureSettingsRequest)PARSER.parse(parser, null);
                nodesRequestBuilder.setSecureStorePassword(nodesRequest.getSecureSettingsPassword());
            }
        }));
        return channel -> nodesRequestBuilder.execute(new RestBuilderListener<NodesReloadSecureSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                ((NodesReloadSecureSettingsRequest)nodesRequestBuilder.request()).closePassword();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString((request, value) -> request.setSecureStorePassword(new SecureString(value.toCharArray())), new ParseField("secure_settings_password", new String[0]));
        FILTERED_FIELDS = Collections.singleton("secure_settings_password");
    }
}

