/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.search.aggregations.AggregationCollectorManager;
import org.opensearch.search.aggregations.AggregationInitializationException;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.aggregations.GlobalAggCollectorManager;
import org.opensearch.search.aggregations.GlobalAggCollectorManagerWithSingleCollector;
import org.opensearch.search.aggregations.NonGlobalAggCollectorManager;
import org.opensearch.search.aggregations.NonGlobalAggCollectorManagerWithSingleCollector;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.query.InternalProfileComponent;
import org.opensearch.search.query.QueryPhaseExecutionException;

public class DefaultAggregationProcessor
implements AggregationProcessor {
    @Override
    public void preProcess(SearchContext context) {
        try {
            if (context.aggregations() != null) {
                if (context.aggregations().factories().hasNonGlobalAggregator()) {
                    context.queryCollectorManagers().put(NonGlobalAggCollectorManager.class, new NonGlobalAggCollectorManagerWithSingleCollector(context));
                }
                if (context.aggregations().factories().hasGlobalAggregator()) {
                    context.queryCollectorManagers().put(GlobalAggCollectorManager.class, new GlobalAggCollectorManagerWithSingleCollector(context));
                }
            }
        }
        catch (IOException ex) {
            throw new AggregationInitializationException("Could not initialize aggregators", ex);
        }
    }

    @Override
    public void postProcess(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().hasAggs()) {
            return;
        }
        AggregationCollectorManager nonGlobalCollectorManager = (AggregationCollectorManager)context.queryCollectorManagers().get(NonGlobalAggCollectorManager.class);
        AggregationCollectorManager globalCollectorManager = (AggregationCollectorManager)context.queryCollectorManagers().get(GlobalAggCollectorManager.class);
        try {
            if (nonGlobalCollectorManager != null) {
                nonGlobalCollectorManager.reduce((Collection)List.of()).reduce(context.queryResult());
            }
            try {
                if (globalCollectorManager != null) {
                    Query query = context.buildFilteredQuery(Queries.newMatchAllQuery());
                    if (context.getProfilers() != null) {
                        context.getProfilers().addQueryProfiler().setCollector((InternalProfileComponent)globalCollectorManager.newCollector());
                    }
                    context.searcher().search(query, globalCollectorManager.newCollector());
                    globalCollectorManager.reduce((Collection)List.of()).reduce(context.queryResult());
                }
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context.shardTarget(), "Failed to execute global aggregators", e);
            }
        }
        catch (IOException ex) {
            throw new QueryPhaseExecutionException(context.shardTarget(), "Post processing failed for aggregators", ex);
        }
        context.aggregations(null);
        context.queryCollectorManagers().remove(NonGlobalAggCollectorManager.class);
        context.queryCollectorManagers().remove(GlobalAggCollectorManager.class);
    }
}

