/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;

public abstract class ParsedSingleBucketAggregation
extends ParsedAggregation
implements SingleBucketAggregation {
    private long docCount;
    protected Aggregations aggregations = new Aggregations(Collections.emptyList());

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    protected void setDocCount(long docCount) {
        this.docCount = docCount;
    }

    @Override
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }

    protected static <T extends ParsedSingleBucketAggregation> T parseXContent(XContentParser parser, T aggregation, String name) throws IOException {
        aggregation.setName(name);
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = parser.currentName();
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList aggregations = new ArrayList();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                aggregation.setDocCount(parser.longValue());
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (Aggregation.CommonFields.META.getPreferredName().equals(currentFieldName)) {
                aggregation.metadata = parser.map();
                continue;
            }
            XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, aggregations::add);
        }
        aggregation.aggregations = new Aggregations(aggregations);
        return aggregation;
    }
}

