/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

class CompositeKey
implements Writeable {
    private final Comparable[] values;

    CompositeKey(Comparable ... values) {
        this.values = values;
    }

    CompositeKey(StreamInput in) throws IOException {
        this.values = (Comparable[])in.readArray(i -> (Comparable)i.readGenericValue(), Comparable[]::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(StreamOutput::writeGenericValue, (Object[])this.values);
    }

    Comparable[] values() {
        return this.values;
    }

    int size() {
        return this.values.length;
    }

    Comparable get(int pos) {
        assert (pos < this.values.length);
        return this.values[pos];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeKey that = (CompositeKey)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return "CompositeKey{values=" + Arrays.toString(this.values) + "}";
    }
}

