/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.io.stream.NamedWriteable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.opensearch.search.aggregations.support.AggregationPath;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected final DocValueFormat format;
    protected final BucketHelpers.GapPolicy gapPolicy;

    BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.gapPolicy = gapPolicy;
        this.format = format;
    }

    BucketMetricsPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    public final void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        this.gapPolicy.writeTo(out);
        this.innerWriteTo(out);
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    public final InternalAggregation doReduce(Aggregations aggregations, InternalAggregation.ReduceContext context) {
        this.preCollection();
        List<String> bucketsPath = AggregationPath.parse(this.bucketsPaths()[0]).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(bucketsPath.get(0))) continue;
            List<String> sublistedPath = bucketsPath.subList(1, bucketsPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List buckets = multiBucketsAgg.getBuckets();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, bucket, sublistedPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(this.metadata());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(Map<String, Object> var1);

    protected abstract void collectBucketValue(String var1, Double var2);
}

