/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.common.io.stream.NamedWriteable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.script.BucketAggregationScript;
import org.opensearch.script.Script;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.InternalSimpleValue;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketScriptPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Script script;
    private final Map<String, String> bucketsPathsMap;

    BucketScriptPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[0]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
    }

    public BucketScriptPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.formatter = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPathsMap = (Map)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.formatter);
        this.gapPolicy.writeTo(out);
        out.writeGenericValue(this.bucketsPathsMap);
    }

    @Override
    public String getWriteableName() {
        return "bucket_script";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List buckets = originalAgg.getBuckets();
        BucketAggregationScript.Factory factory = reduceContext.scriptService().compile(this.script, BucketAggregationScript.CONTEXT);
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (this.script.getParams() != null) {
                vars.putAll(this.script.getParams());
            }
            boolean skipBucket = false;
            for (Map.Entry<String, String> entry : this.bucketsPathsMap.entrySet()) {
                String varName = entry.getKey();
                String bucketsPath = entry.getValue();
                Double value = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)originalAgg, bucket, bucketsPath, this.gapPolicy);
                if (BucketHelpers.GapPolicy.SKIP == this.gapPolicy && (value == null || Double.isNaN(value))) {
                    skipBucket = true;
                    break;
                }
                vars.put(varName, value);
            }
            if (skipBucket) {
                newBuckets.add(bucket);
                continue;
            }
            Number returned = factory.newInstance(vars).execute();
            if (returned == null) {
                newBuckets.add(bucket);
                continue;
            }
            List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
            InternalSimpleValue simpleValue = new InternalSimpleValue(this.name(), returned.doubleValue(), this.formatter, this.metadata());
            aggs.add(simpleValue);
            InternalMultiBucketAggregation.InternalBucket newBucket = originalAgg.createBucket(InternalAggregations.from(aggs), bucket);
            newBuckets.add(newBucket);
        }
        return originalAgg.create(newBuckets);
    }
}

