/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.ParseField;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public enum ValueType implements Writeable
{
    STRING(1, "string", "string", CoreValuesSourceType.BYTES, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DOUBLE(3, "float|double", "double", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    NUMBER(4, "number", "number", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DATE(5, "date", "date", CoreValuesSourceType.DATE, new DocValueFormat.DateTime(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, ZoneOffset.UTC, DateFieldMapper.Resolution.MILLISECONDS)),
    IP(6, "ip", "ip", CoreValuesSourceType.IP, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    GEOPOINT(8, "geo_point", "geo_point", CoreValuesSourceType.GEOPOINT, DocValueFormat.GEOHASH),
    BOOLEAN(9, "boolean", "boolean", CoreValuesSourceType.BOOLEAN, DocValueFormat.BOOLEAN),
    RANGE(10, "range", "range", CoreValuesSourceType.RANGE, DocValueFormat.RAW),
    UNSIGNED_LONG(11, "unsigned_long", "unsigned_long", CoreValuesSourceType.NUMERIC, DocValueFormat.UNSIGNED_LONG);

    final String description;
    final ValuesSourceType valuesSourceType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private String preferredName;
    public static final ParseField VALUE_TYPE;
    private static List<ValueType> numericValueTypes;
    private static List<ValueType> stringValueTypes;

    private ValueType(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.defaultFormat = defaultFormat;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean isA(ValueType valueType) {
        if (numericValueTypes.contains((Object)this)) {
            return numericValueTypes.contains((Object)valueType);
        }
        if (stringValueTypes.contains((Object)this)) {
            return stringValueTypes.contains((Object)valueType);
        }
        return this.equals((Object)valueType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public DocValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public static ValueType lenientParse(String type) {
        switch (type) {
            case "string": {
                return STRING;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
            case "number": 
            case "numeric": 
            case "long": 
            case "integer": 
            case "short": 
            case "byte": {
                return LONG;
            }
            case "unsigned_long": {
                return UNSIGNED_LONG;
            }
            case "date": {
                return DATE;
            }
            case "ip": {
                return IP;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        return null;
    }

    public String toString() {
        return this.description;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        for (ValueType valueType : ValueType.values()) {
            if (id != valueType.id) continue;
            return valueType;
        }
        throw new IOException("No ValueType found for id [" + id + "]");
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    static {
        VALUE_TYPE = new ParseField("value_type", new String[]{"valueType"});
        numericValueTypes = Arrays.asList(DOUBLE, DATE, LONG, UNSIGNED_LONG, NUMBER, NUMERIC, BOOLEAN);
        stringValueTypes = Arrays.asList(STRING, IP);
    }
}

