/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.action.search.SearchType;
import org.opensearch.common.Nullable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.ParsedQuery;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.search.RescoreDocIds;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.SearchContextAggregations;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchDocValuesContext;
import org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.fetch.subphase.ScriptFieldsContext;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.profile.Profilers;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.sort.SortAndFormats;
import org.opensearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    public static final int TRACK_TOTAL_HITS_ACCURATE = Integer.MAX_VALUE;
    public static final int TRACK_TOTAL_HITS_DISABLED = -1;
    public static final int DEFAULT_TRACK_TOTAL_HITS_UP_TO = 10000;
    private final List<Releasable> releasables = new CopyOnWriteArrayList<Releasable>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;
    private volatile boolean searchTimedOut;

    protected SearchContext() {
    }

    public abstract void setTask(SearchShardTask var1);

    public abstract SearchShardTask getTask();

    public abstract boolean isCancelled();

    public boolean isSearchTimedOut() {
        return this.searchTimedOut;
    }

    public void setSearchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                Releasables.close(this.releasables);
            }
            finally {
                this.doClose();
            }
        }
    }

    protected abstract void doClose();

    public abstract void preProcess(boolean var1);

    public abstract Query buildFilteredQuery(Query var1);

    public abstract ShardSearchContextId id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract float queryBoost();

    public abstract ScrollContext scrollContext();

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract void addSearchExt(SearchExtBuilder var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchHighlightContext highlight();

    public abstract void highlight(SearchHighlightContext var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract List<RescoreContext> rescore();

    public abstract void addRescore(RescoreContext var1);

    public final RescoreDocIds rescoreDocIds() {
        List<RescoreContext> rescore = this.rescore();
        if (rescore == null) {
            return RescoreDocIds.EMPTY;
        }
        HashMap<Integer, Set<Integer>> rescoreDocIds = null;
        for (int i = 0; i < rescore.size(); ++i) {
            Set<Integer> docIds = rescore.get(i).getRescoredDocs();
            if (docIds == null || docIds.isEmpty()) continue;
            if (rescoreDocIds == null) {
                rescoreDocIds = new HashMap<Integer, Set<Integer>>();
            }
            rescoreDocIds.put(i, docIds);
        }
        return rescoreDocIds == null ? RescoreDocIds.EMPTY : new RescoreDocIds(rescoreDocIds);
    }

    public final void assignRescoreDocIds(RescoreDocIds rescoreDocIds) {
        List<RescoreContext> rescore = this.rescore();
        if (rescore != null) {
            for (int i = 0; i < rescore.size(); ++i) {
                Set<Integer> docIds = rescoreDocIds.getId(i);
                if (docIds == null) continue;
                rescore.get(i).setRescoredDocs(docIds);
            }
        }
    }

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract FetchDocValuesContext docValuesContext();

    public abstract SearchContext docValuesContext(FetchDocValuesContext var1);

    public abstract FetchFieldsContext fetchFieldsContext();

    public abstract SearchContext fetchFieldsContext(FetchFieldsContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract MapperService mapperService();

    public abstract SimilarityService similarityService();

    public abstract BigArrays bigArrays();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract TimeValue timeout();

    public abstract void timeout(TimeValue var1);

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(SortAndFormats var1);

    public abstract SortAndFormats sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext trackTotalHitsUpTo(int var1);

    public abstract int trackTotalHitsUpTo();

    public abstract SearchContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract SearchContext collapse(CollapseContext var1);

    public abstract CollapseContext collapse();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract Query aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasStoredFields();

    public abstract boolean hasStoredFieldsContext();

    public abstract boolean storedFieldsRequested();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchContext storedFieldsContext(StoredFieldsContext var1);

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract boolean seqNoAndPrimaryTerm();

    public abstract void seqNoAndPrimaryTerm(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract DfsSearchResult dfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract FetchPhase fetchPhase();

    public abstract FetchSearchResult fetchResult();

    public abstract Profilers getProfilers();

    public boolean isConcurrentSegmentSearchEnabled() {
        return false;
    }

    public void addReleasable(Releasable releasable) {
        this.releasables.add(releasable);
    }

    public final boolean hasOnlySuggest() {
        return this.request().source() != null && this.request().source().isSuggestOnly();
    }

    public abstract MappedFieldType fieldType(String var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract long getRelativeTimeInMillis();

    public long getRelativeTimeInMillis(boolean useCache) {
        if (useCache) {
            return this.getRelativeTimeInMillis();
        }
        return TimeValue.nsecToMSec((long)System.nanoTime());
    }

    public abstract Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers();

    public abstract QueryShardContext getQueryShardContext();

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.shardTarget());
        if (this.searchType() != SearchType.DEFAULT) {
            result.append("searchType=[").append((Object)this.searchType()).append("]");
        }
        if (this.scrollContext() != null) {
            if (this.scrollContext().scroll != null) {
                result.append("scroll=[").append(this.scrollContext().scroll.keepAlive()).append("]");
            } else {
                result.append("scroll=[null]");
            }
        }
        result.append(" query=[").append(this.query()).append("]");
        return result.toString();
    }

    public abstract ReaderContext readerContext();

    public abstract InternalAggregation.ReduceContext partial();
}

