/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchPipelineProcessingException;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

class Pipeline {
    public static final String REQUEST_PROCESSORS_KEY = "request_processors";
    public static final String RESPONSE_PROCESSORS_KEY = "response_processors";
    public static final String PHASE_PROCESSORS_KEY = "phase_results_processors";
    private static final Logger logger = LogManager.getLogger(Pipeline.class);
    private final String id;
    private final String description;
    private final Integer version;
    private final List<SearchRequestProcessor> searchRequestProcessors;
    private final List<SearchResponseProcessor> searchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> searchPhaseResultsProcessors;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final LongSupplier relativeTimeSupplier;
    static final Pipeline NO_OP_PIPELINE = new Pipeline("_none", "Pipeline that does not transform anything", 0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, () -> 0L);

    Pipeline(String id, @Nullable String description, @Nullable Integer version, List<SearchRequestProcessor> requestProcessors, List<SearchResponseProcessor> responseProcessors, List<SearchPhaseResultsProcessor> phaseResultsProcessors, NamedWriteableRegistry namedWriteableRegistry, LongSupplier relativeTimeSupplier) {
        this.id = id;
        this.description = description;
        this.version = version;
        this.searchRequestProcessors = Collections.unmodifiableList(requestProcessors);
        this.searchResponseProcessors = Collections.unmodifiableList(responseProcessors);
        this.searchPhaseResultsProcessors = Collections.unmodifiableList(phaseResultsProcessors);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.relativeTimeSupplier = relativeTimeSupplier;
    }

    String getId() {
        return this.id;
    }

    String getDescription() {
        return this.description;
    }

    Integer getVersion() {
        return this.version;
    }

    List<SearchRequestProcessor> getSearchRequestProcessors() {
        return this.searchRequestProcessors;
    }

    List<SearchResponseProcessor> getSearchResponseProcessors() {
        return this.searchResponseProcessors;
    }

    List<SearchPhaseResultsProcessor> getSearchPhaseResultsProcessors() {
        return this.searchPhaseResultsProcessors;
    }

    protected void beforeTransformRequest() {
    }

    protected void afterTransformRequest(long timeInNanos) {
    }

    protected void onTransformRequestFailure() {
    }

    protected void beforeRequestProcessor(Processor processor) {
    }

    protected void afterRequestProcessor(Processor processor, long timeInNanos) {
    }

    protected void onRequestProcessorFailed(Processor processor) {
    }

    protected void beforeTransformResponse() {
    }

    protected void afterTransformResponse(long timeInNanos) {
    }

    protected void onTransformResponseFailure() {
    }

    protected void beforeResponseProcessor(Processor processor) {
    }

    protected void afterResponseProcessor(Processor processor, long timeInNanos) {
    }

    protected void onResponseProcessorFailed(Processor processor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchRequest transformRequest(SearchRequest request) throws SearchPipelineProcessingException {
        if (!this.searchRequestProcessors.isEmpty()) {
            long pipelineStart = this.relativeTimeSupplier.getAsLong();
            this.beforeTransformRequest();
            try {
                try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
                    request.writeTo((StreamOutput)bytesStreamOutput);
                    try (StreamInput in = bytesStreamOutput.bytes().streamInput();
                         NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);){
                        request = new SearchRequest(input);
                    }
                }
                for (SearchRequestProcessor processor : this.searchRequestProcessors) {
                    this.beforeRequestProcessor(processor);
                    long start = this.relativeTimeSupplier.getAsLong();
                    try {
                        request = processor.processRequest(request);
                    }
                    catch (Exception e) {
                        this.onRequestProcessorFailed(processor);
                        if (processor.isIgnoreFailure()) {
                            logger.warn("The exception from request processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                        this.afterRequestProcessor(processor, took);
                    }
                }
            }
            catch (Exception e) {
                this.onTransformRequestFailure();
                throw new SearchPipelineProcessingException(e);
            }
            finally {
                long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart);
                this.afterTransformRequest(took);
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchResponse transformResponse(SearchRequest request, SearchResponse response) throws SearchPipelineProcessingException {
        if (!this.searchResponseProcessors.isEmpty()) {
            long pipelineStart = this.relativeTimeSupplier.getAsLong();
            this.beforeTransformResponse();
            try {
                for (SearchResponseProcessor processor : this.searchResponseProcessors) {
                    this.beforeResponseProcessor(processor);
                    long start = this.relativeTimeSupplier.getAsLong();
                    try {
                        response = processor.processResponse(request, response);
                    }
                    catch (Exception e) {
                        this.onResponseProcessorFailed(processor);
                        if (processor.isIgnoreFailure()) {
                            logger.warn("The exception from response processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - start);
                        this.afterResponseProcessor(processor, took);
                    }
                }
            }
            catch (Exception e) {
                this.onTransformResponseFailure();
                throw new SearchPipelineProcessingException(e);
            }
            finally {
                long took = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeSupplier.getAsLong() - pipelineStart);
                this.afterTransformResponse(took);
            }
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <Result extends SearchPhaseResult> void runSearchPhaseResultsTransformer(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext context, String currentPhase, String nextPhase) throws SearchPipelineProcessingException {
        try {
            for (SearchPhaseResultsProcessor searchPhaseResultsProcessor : this.searchPhaseResultsProcessors) {
                if (!currentPhase.equals(searchPhaseResultsProcessor.getBeforePhase().getName()) || !nextPhase.equals(searchPhaseResultsProcessor.getAfterPhase().getName())) continue;
                try {
                    searchPhaseResultsProcessor.process(searchPhaseResult, context);
                }
                catch (Exception e) {
                    if (!searchPhaseResultsProcessor.isIgnoreFailure()) throw e;
                    logger.warn("The exception from search phase results processor [" + searchPhaseResultsProcessor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                    continue;
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw new SearchPipelineProcessingException(e);
        }
    }
}

