/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.rescore;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public enum QueryRescoreMode implements Writeable
{
    Avg{

        @Override
        public float combine(float primary, float secondary) {
            return (primary + secondary) / 2.0f;
        }

        @Override
        public String toString() {
            return "avg";
        }
    }
    ,
    Max{

        @Override
        public float combine(float primary, float secondary) {
            return Math.max(primary, secondary);
        }

        @Override
        public String toString() {
            return "max";
        }
    }
    ,
    Min{

        @Override
        public float combine(float primary, float secondary) {
            return Math.min(primary, secondary);
        }

        @Override
        public String toString() {
            return "min";
        }
    }
    ,
    Total{

        @Override
        public float combine(float primary, float secondary) {
            return primary + secondary;
        }

        @Override
        public String toString() {
            return "sum";
        }
    }
    ,
    Multiply{

        @Override
        public float combine(float primary, float secondary) {
            return primary * secondary;
        }

        @Override
        public String toString() {
            return "product";
        }
    };


    public abstract float combine(float var1, float var2);

    public static QueryRescoreMode readFromStream(StreamInput in) throws IOException {
        return (QueryRescoreMode)in.readEnum(QueryRescoreMode.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static QueryRescoreMode fromString(String scoreMode) {
        for (QueryRescoreMode mode : QueryRescoreMode.values()) {
            if (!scoreMode.toLowerCase(Locale.ROOT).equals(mode.name().toLowerCase(Locale.ROOT))) continue;
            return mode;
        }
        throw new IllegalArgumentException("illegal score_mode [" + scoreMode + "]");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

