/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.tasks.TaskAwareRequest;
import org.opensearch.tasks.TaskId;
import org.opensearch.transport.TransportMessage;

public abstract class TransportRequest
extends TransportMessage
implements TaskAwareRequest {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;

    public TransportRequest() {
    }

    public TransportRequest(StreamInput in) throws IOException {
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    @Override
    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.parentTaskId.writeTo(out);
    }

    public static class Empty
    extends TransportRequest {
        public static final Empty INSTANCE = new Empty();

        public Empty() {
        }

        public Empty(StreamInput in) throws IOException {
            super(in);
        }
    }
}

